<div>
    <table class="table table-bordered" id="transaction-table">
        <thead class="thead-light">
            <tr>
                <th>
                    <a class="text-muted">
                        Type
                    </a>
                </th>

                <th>
                    <a class="text-muted">
                        Credit/Debit
                    </a>
                </th>
                <th>
                    <a class="text-muted">
                        Date
                    </a>
                </th>
                <th>
                    <a class="text-muted">
                        Amount
                    </a>
                </th>
                <th>
                    <a class="text-muted">
                        Status
                    </a>
                </th>
                <th>
                    <a class="text-muted">
                        View Details
                    </a>
                </th>
            </tr>
        </thead>
        <tbody class="list">
            @foreach ($transactions as $transaction)
                <tr>
                    <td class="currency"><span>{{ transaction_type($transaction->transaction_type) }}</span></td>
                    <td>
                        <span @class([
                            'badge',
                            'text-bg-success' => $transaction->alert_type == 'Credit',
                            'text-bg-danger' => $transaction->alert_type == 'Debit',
                        ])>
                            {{ $transaction->alert_type }}
                        </span>
                    </td>
                    <td>{{ $transaction->date }}</td>
                    <td>{{ currencyLogo($transaction->currency) }} {{ number_format($transaction->amount, 2) }}</td>
                    <td>
                        <span
                            class="badge @if ($transaction->status == 1) text-bg-success @elseif($transaction->status == 2)text-bg-info @else text-bg-danger @endif">
                            {{ status($transaction->status) }}
                        </span>
                    </td>
                    <td>
                        @if ($transaction->status == 3)
                            <a href="{{ route('transaction.details', $transaction->id) }}">
                                <button class="custom-btn btn btn-primary">Confirm Transaction</button>
                            </a>
                        @else
                            <a href="{{ route('transaction.details', $transaction->id) }}">
                                <button class="custom-btn btn btn-primary">View</button>
                            </a>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <script>
        new DataTable('#transaction-table', {
            layout: {
                topStart: {
                    buttons: [
                        'copy', 'excel', 'pdf', 'print'
                    ]
                }
            }
        });
    </script>
</div>
