@extends('layouts.install')

@section('content')
<div>
  <!-- Title -->
  <h1 class="mb-4">
    Zincvault Installer
  </h1>

  <!-- Subtitle -->
  <h3 class="mt-5">
    Database Information
  </h3>
  <div class="alert alert-danger" id="error" style="display: none"></div>
  <div class="alert alert-success" id="success" style="display: none"></div>
  <!-- Form -->
  <form method="POST" action="{{route('install.first')}}" id="installFirst">
    @csrf
    <div class="row">
      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Host Name
          </label>

          <!-- Input -->
          <input type="text" name="host_name" class="form-control" value="127.0.0.1" placeholder="127.0.0.1">
        </div>
      </div>

      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Database Name
          </label>

          <!-- Input -->
          <input type="text" class="form-control" name="database_name" placeholder="Your Database Name">
        </div>
      </div>

      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Database Username
          </label>

          <!-- Input -->
          <input type="text" class="form-control" name="database_username" placeholder="Your Database Username">
        </div>
      </div>

      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Database Password
            <span class="badge bg-info">Should not contain '#'</span>
          </label>

          <!-- Input -->
          <input type="password" class="form-control" name="database_password" placeholder="Your Database Password"
            value="">
        </div>
      </div>

    </div> <!-- / .row -->

    <!-- Button -->
    <button id="loading" class="btn btn-primary" type="button" disabled style="display: none">
      <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
      <span class="sr-only"></span>
    </button>
    <button type="text" id="done" class="btn btn-primary mt-3">
      Install
    </button>
  </form>
</div>

<div class="mt-10">

</div>
@endsection