@extends('layouts.app')
@section('title', 'Create Account')
@section('content')
<div>
  <!-- Title -->
  <h1 class="mb-2">
    Create Account
  </h1>

  <!-- Subtitle -->
  <p class="text-secondary">
    Don't have an account? Create your account, it takes less than a minute
  </p>

  <!-- Form -->
  <form method="POST" action="{{ route('register') }}">
    @csrf

    <div class="row mb-3">
      <label for="name" class="col-md-4 col-form-label text-md-end">{{ __('Name') }}</label>

      <div class="col-md-6">
        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name"
          value="{{ old('name') }}" required autocomplete="name" autofocus placeholder="Your Full Name" />

        @error('name')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
      </div>
    </div>

    <div class="row mb-3">
      <label for="email" class="col-md-4 col-form-label text-md-end">{{ __('Email Address') }}</label>

      <div class="col-md-6">
        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email"
          value="{{ old('email') }}" required autocomplete="email" placeholder="Your Email Address">

        @error('email')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
      </div>
    </div>

    <div class="row mb-3">
      <label for="phone" class="col-md-4 col-form-label text-md-end">{{ __('Phone Number') }}</label>

      <div class="col-md-6">
        <input id="phone_number" type="phone_number" class="form-control @error('phone_number') is-invalid @enderror"
          name="phone_number" value="{{ old('phone_number') }}" required autocomplete="phone"
          placeholder="Your Phone Number">

        @error('phone_number')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
      </div>
    </div>

    <div class="row mb-3">
      <label for="account_type" class="col-md-4 col-form-label text-md-end">{{ __('Account Type')
        }}</label>

      <div class="col-md-6">
        <select class="form-select @error('account_type') is-invalid @enderror" required name="account_type">
          @if(!empty(old('account_type')))
          <option value="{{old('account_type')}}">{{old('account_type')}}</option>
          @else
          <option selected disabled value="">Select one</option>
          @endif
          <option value="Current Account">Current Account</option>
          <option value="Savings Account">Savings Account</option>
          <option value="Checking Account">Checking Account</option>
        </select>
        @error('account_type')
        <div class="invalid-feedback">
          Please select an option.
        </div>
        @enderror
      </div>
    </div>

    <div class="row mb-3">
      <label for="gender" class="col-md-4 col-form-label text-md-end">{{ __('Gender') }}</label>

      <div class="col-md-6">
        <select class="form-select @error('gender') is-invalid @enderror" id="gender" required name="gender">
          @if(!empty(old('gender')))
          <option value="{{old('gender')}}">{{old('gender')}}</option>
          @else
          <option selected disabled value="">Select One</option>
          @endif
          <option value="Male">Male</option>
          <option value="Female">Female</option>
        </select>
        @error('gender')
        <div class="invalid-feedback">
          Please select an option.
        </div>
        @enderror
      </div>
    </div>
    <div class="row mb-3">
      <label for="timezone" class="col-md-4 col-form-label text-md-end">{{ __('Timezone') }}</label>

      <div class="col-md-6">
        <select class="form-select @error('timezone') is-invalid @enderror" id="timezone" required name="timezone">
          @if(!empty(old('timezone')))
          <option value="{{old('timezone')}}">{{old('timezone')}}</option>
          @else
          <option selected disabled value="">Select One</option>
          @endif
          @foreach ($timezones as $timezone)
          <option value="{{$timezone}}">{{$timezone}}</option>
          @endforeach
        </select>
        @error('timezone')
        <div class="invalid-feedback">
          Please select an option.
        </div>
        @enderror

        @error('username')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
      </div>
    </div>
    <div class="row mb-3">
      <label for="username" class="col-md-4 col-form-label text-md-end">{{ __('Username') }}</label>

      <div class="col-md-6">
        <input id="username" type="username" class="form-control @error('username') is-invalid @enderror"
          name="username" value="{{ old('username') }}" required autocomplete="username"
          placeholder="Your Unique Username">

        @error('username')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
      </div>
    </div>

    <div class="row mb-3">
      <label for="password" class="col-md-4 col-form-label text-md-end">{{ __('Password') }}</label>

      <div class="col-md-6">
        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror"
          name="password" required placeholder="Your Password">

        @error('password')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
      </div>
    </div>

    <div class="row mb-3">
      <label for="password-confirm" class="col-md-4 col-form-label text-md-end">{{ __('Confirm
        Password') }}</label>

      <div class="col-md-6">
        <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required
          autocomplete="new-password" placeholder="Confirm Password">
      </div>
    </div>

    <div class="row mb-0">
      <div class="col-md-6 offset-md-4">
        <button type="submit" class="btn btn-primary">
          {{ __('Register') }}
        </button>
      </div>
    </div>
  </form>
</div>

<div class="mt-auto">

  <!-- Link -->
  <small class="mb-0 text-muted">
    Already registered? <a href="{{route('login')}}" class="fw-semibold">Login</a>
  </small>
</div>

</div>

<div class="col-md-5 col-lg-6 d-none d-lg-block">

  <!-- Image -->
  <div class="bg-size-cover bg-position-center bg-repeat-no-repeat overlay overlay-dark overlay-50 vh-100 me-n4"
    style="background-image: url(assets/images/covers/sign-up-cover.jpg);"></div>
</div>
@endsection