@extends('includes.adminlayout')
@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <h3 class="text-center">Deposit Details</h3>
            <hr>
            <form method="POST" x-data="manage_deposit" x-ref="deposit_form">
                @csrf
                <div class="row">
                    <div class="mb-3 col-md-12 mb-5 col-sm-12">
                        <label class="form-label">
                            User
                            <a href="{{ route('admin.user-edit', $deposit->user->id) }}"> <i class="fa fa-user"></i>
                            </a>
                        </label>
                        <x-form.input type="text" name="holder_name" class="form-control"
                            value="{{ $deposit->user->name }}" readonly />
                    </div>

                    <div class="mb-3 col-md-6 mb-5 col-sm-12">
                        <label class="form-label">Method</label>
                        <x-form.select name="deposit_method_id" class="form-select">
                            <option value="">Select a method</option>
                            @foreach($deposit_methods as $method)
                            <option value="{{ $method->id }}" @selected($method->id==$deposit->deposit_method_id)>{{
                                $method->name }}
                            </option>
                            @endforeach
                        </x-form.select>
                    </div>

                    <div class="mb-3 col-md-6 mb-5 col-sm-12">
                        <label class="form-label">Amount</label>
                        <div class="input-group">
                            <div class="input-group-text">{{ $deposit->currency }}</div>
                            <x-form.input name="amount" class="form-control"
                                value="{{ old('amount', $deposit->amount) }}" />
                        </div>
                    </div>

                    <div class="mb-3 col-md-6 mb-5 col-sm-12">
                        <label class="form-label">Comment</label>
                        <x-form.input name="comment" class="form-control"
                            value="{{ old('comment', $deposit->comment) }}" />
                    </div>
                    
                    <div class="mb-3 col-md-6 mb-5 col-sm-12">
                        <label class="form-label">Status</label>
                        <x-form.select name="status" class="form-select" x-model="status">
                            <option value="">Select a card type</option>
                            <option value="approved">Approved</option>
                            <option value="pending">Pending</option>
                            <option value="rejected">Rejected</option>
                        </x-form.select>
                    </div>

                    <div class="mb-3 col-12 mb-5" x-show="status=='rejected'" x-cloak>
                        <label class="form-label">Reject Reason</label>
                        <x-form.textarea name="reject_reason" class="form-control" rows="4">{{ old('reject_reason',
                            $deposit->reject_reason) }}</x-form.textarea>
                    </div>
                    <div class="col-12">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" name="send_email" checked />
                            <label class="form-check-label">Send Email</label>
                        </div>
                    </div>
                    <div class="mb-3 col-12 d-flex mb-5 justify-content-end">
                        <a class="btn btn-danger mx-5" href="{{ route('admin.deposits.delete', $deposit->id) }}">Delete</a>
                        <button class="btn btn-primary" @click.prevent="confirmAction" type="button">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('alpine:init', () => {
    
    Alpine.data('manage_deposit', () => ({
        status: @js($deposit -> status),
        confirmAction() {
            Notiflix.Confirm.show(
                `Confirm Action`,
                `Are you sure you want to set this deposit to ${this.status}.
                This action is irreversible.
                `,
                `Yes`,
                'No',
                () => {
                    this.$refs.deposit_form.submit()
                },
            );
        }
    }))
})
</script>
@endsection