@extends('includes.adminlayout')

@section('content')
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Manage Deposit Methods <button class="btn btn-sm btn-secondary dropdown-toggle" type="button"
            id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
            Create Deposit Method
        </button>
        <div class="dropdown">
            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                <li><a class="dropdown-item" href="{{ route('settings.methods.create-bank') }}">Bank</a></li>
                <li><a class="dropdown-item" href="{{ route('settings.methods.create-crypto') }}">Crypto</a></li>
            </ul>
        </div>
    </h1>

    <div class="row">
        <div class="col">
            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            Name
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Type
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">

                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                @forelse ($deposit_methods as $method)
                                <tr>
                                    <td> {{ $method->name }} </td>
                                    <td> {{ $method->type }} </td>
                                    <td>
                                        <span @class([ 'badge' , 'bg-success'=> $method->is_active,
                                            'bg-danger' => !$method->is_active,
                                            ])>
                                            {{ $method->status }}
                                        </span>
                                    </td>
                                    <td> <a href="{{ route('settings.deposit-methods.single', $method->id) }}"
                                            class="badge bg-info">View</a> </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" align="center" class="fw-bold">No loan requests yet.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="mt-6 p-4">
                {{ $deposit_methods->links() }}
            </div>
        </div>
    </div>
</div>
@endsection