<div class="container-fluid">
    <div class="header__row row justify-content-between">
        <div class="header__col-left col d-flex align-items-center ">
            <div class="header__left-toggle">
                <button class="header__toggle-menu toggle-sidebar" type="button">
                    <svg class="icon-icon-grid" style="color:white">
                        <use xlink:href="#icon-grid"></use>
                    </svg>
                </button>
            </div>
            <div class="header__">
                <div id="google_translate_element">
                    <div class="skiptranslate goog-te-gadget" dir="ltr" s="">
                        <div id=":0.targetLanguage" class="goog-te-gadget-simple" style="white-space: nowrap;">
                        </div>
                    </div>
                    <script type="text/javascript">
                        function googleTranslateElementInit() {
                                    new google.translate.TranslateElement({
                                        pageLanguage: 'en', 
                                        layout: google.translate.TranslateElement.InlineLayout.SIMPLE,
                                        autoDisplay: false,
                                    }, 'google_translate_element');}
                    </script>
                </div>
            </div>
        </div>

        <div class="header__col-right col d-flex align-items-center">

            <div class="header__tools">
                <div class="header__notes header__tools-item">
                    <a class="header__tools-toggle" href="mailto:{{ $settings->site_name }}"
                        data-tippy-content="Notifications" data-tippy-placement="bottom">
                        <svg class="icon-icon-message text-white">
                            <use xlink:href="#icon-message"></use>
                        </svg> <span class="badge-signal"></span>
                    </a>
                </div>
                <div class="header__messages header__tools-item">
                    <a class="header__tools-toggle header__tools-toggle--bell" href="#" data-tippy-content="Messages"
                        data-tippy-placement="bottom" data-toggle="dropdown">
                        <svg class="icon-icon-bell text-white">
                            <use xlink:href="#icon-bell"></use>
                        </svg> 
                        @if(count($user->unreadNotifications))
                        <span class="badge-signal"></span>
                        @endif
                    </a>
                    <div class="dropdown-menu">
                        <div class="dropdown-menu__top dropdown-menu__item"><span
                                class="dropdown-menu__title">Messages</span>
                            <span class="badge badge--red">{{ count($user->unreadNotifications) }}</span>
                            @if(count($user->unreadNotifications))
                            <a class="dropdown-menu__clear-all" href="{{ route('dashboard.read-notifications') }}" role="button">Clear All</a>
                            @endif
                        </div>
                        <div class="dropdown-menu__items scrollbar-thin scrollbar-visible"
                            data-simplebar="data-simplebar">
                            
                            @foreach($user->unreadNotifications as $notification)
                            <x-widgets.notification-item :$notification />
                            @endforeach

                        </div>

                        <div class="dropdown-menu__divider"></div>
                        
                        @if(count($user->unreadNotifications))
                        <a class="dropdown-menu__item dropdown-menu__link-all" href="#">
                            View all Messages
                            <svg class="icon-icon-keyboard-right">
                                <use xlink:href="#icon-keyboard-right"></use>
                            </svg>
                        </a>

                        @else

                        <a class="dropdown-menu__item dropdown-menu__link-all" href="#">
                            No new message.
                            <svg class="icon-icon-keyboard-right">
                                <use xlink:href="#icon-keyboard-right"></use>
                            </svg>
                        </a>
                        @endif

                    </div>
                </div>
            </div>
            <div class="header__profile dropdown">
                <a class="header__profile-toggle dropdown__toggle" href="#" data-toggle="dropdown">
                    <div class="header__profile-image"><span class="header__profile-image-text">SH</span>
                        <img src="{{ $user->details->avatar }}" alt="" />
                    </div>
                    <div class="header__profile-text text-white"><span>{{ $user->name }}</span>
                    </div><span class="icon-arrow-down">
                        <svg class="icon-icon-arrow-down">
                            <use xlink:href="#icon-arrow-down"></use>
                        </svg></span>
                </a>
                <div class="profile-dropdown dropdown-menu dropdown-menu--right">
                    <a class="profile-dropdown__item dropdown-menu__item" href="{{ route('dashboard.profile') }}"
                        tabindex="0"><span class="profile-dropdown__icon">
                            <svg class="icon-icon-user">
                                <use xlink:href="#icon-user"></use>
                            </svg></span><span>My Profile</span></a>
                    <a class="profile-dropdown__item dropdown-menu__item" href="{{ route('dashboard.password') }}"
                        tabindex="0"><span class="profile-dropdown__icon">
                            <svg class="icon-icon-password">
                                <use xlink:href="#icon-password"></use>
                            </svg></span><span>Change Password</span></a>
                    <div class="dropdown-menu__divider"></div><a class="profile-dropdown__item dropdown-menu__item"
                        href="{{ route('logout') }}" tabindex="0"><span class="profile-dropdown__icon">
                            <svg class="icon-icon-logout">
                                <use xlink:href="#icon-logout"></use>
                            </svg></span><span>Logout</span></a>
                </div>
            </div>
        </div>
    </div>
</div>