<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme CSS -->
  <link rel="stylesheet" href="/assets/css/theme.bundle.css" id="stylesheetLTR" />
  <link rel="stylesheet" href="/assets/css/theme.rtl.bundle.css" id="stylesheetRTL" />

  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link rel="preload" as="style"
    href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
  <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');"
    href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
  <script src="https://cdn.jsdelivr.net/npm/pace-js@latest/pace.min.js"></script>
  <link rel="stylesheet" href="{{asset('/assets/css/flash.css')}}" />
  <link rel="stylesheet" href="{{asset('/assets/izitoast/dist/css/izitoast.min.css')}}" />
  <script src="{{asset('/assets/izitoast/dist/js/izitoast.min.js')}}"></script>
  <script src="https://code.jquery.com/jquery-3.6.1.js"></script>
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
  <!-- no-JS fallback -->
  <noscript>
    <link rel="stylesheet"
      href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
  </noscript>

  <script>
    // Theme switcher
        
            let themeSwitcher = document.getElementById('themeSwitcher');
        
            const getPreferredTheme = () => {
                if (localStorage.getItem('theme') != null) {
                    return localStorage.getItem('theme');
                }
        
                return document.documentElement.dataset.theme;
            };
        
            const setTheme = function (theme) {
                if (theme === 'auto' && window.matchMedia('(prefers-color-scheme: dark)').matches) {
                    document.documentElement.dataset.theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
                } else {
                    document.documentElement.dataset.theme = theme;
                }
        
                localStorage.setItem('theme', theme);
            };
        
            const showActiveTheme = theme => {
                const activeBtn = document.querySelector(`[data-theme-value="${theme}"]`);
        
                document.querySelectorAll('[data-theme-value]').forEach(element => {
                    element.classList.remove('active');
                });
        
                activeBtn && activeBtn.classList.add('active');
        
             // Set button if demo mode is enabled
                document.querySelectorAll('[data-theme-control="theme"]').forEach(element => {
                    if (element.value == theme) {
                        element.checked = true;
                    }
                });
            };
        
            function reloadPage() {
                window.location = window.location.pathname;
            }
        
        
            setTheme(getPreferredTheme());
        
            if(typeof themeSwitcher != 'undefined') {
                window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
                    if(localStorage.getItem('theme') != null) {
                        if (localStorage.getItem('theme') == 'auto') {
                            reloadPage();
                        }
                    }
                });
        
                window.addEventListener('load', () => {
                    showActiveTheme(getPreferredTheme());
                    
                    document.querySelectorAll('[data-theme-value]').forEach(element => {
                        element.addEventListener('click', () => {
                            const theme = element.getAttribute('data-theme-value');
        
                            localStorage.setItem('theme', theme);
                            reloadPage();
                        })
                    })
                });
            }
  </script>
  <!-- Favicon -->
  <link rel="icon" href="/assets/favicon/favicon.ico" sizes="any" />

  <!-- Demo script -->
  <script>
    var themeConfig = {
                    theme: JSON.parse('"light"'),
                    isRTL: JSON.parse('false'),
                    isFluid: JSON.parse('true'),
                    sidebarBehaviour: JSON.parse('"fixed"'),
                    navigationColor: JSON.parse('"inverted"')
                };
                
                var isRTL = localStorage.getItem('isRTL') === 'true',
                    isFluid = localStorage.getItem('isFluid') === 'true',
                    theme = localStorage.getItem('theme'),
                    sidebarSizing = localStorage.getItem('sidebarSizing'),
                    linkLTR = document.getElementById('stylesheetLTR'),
                    linkRTL = document.getElementById('stylesheetRTL'),
                    html = document.documentElement;
        
                if (isRTL) {
                    linkLTR.setAttribute('disabled', '');
                    linkRTL.removeAttribute('disabled');
                    html.setAttribute('dir', 'rtl');
                } else {
                    linkRTL.setAttribute('disabled', '');
                    linkLTR.removeAttribute('disabled');
                    html.removeAttribute('dir');
                }
  </script>

  <!-- Page Title -->
  <title> Zincvault Installer</title>
</head>

<body class="d-flex align-items-center bg-light-green">

  @section('content')
  @if(session('error'))
  <script>
    window.onload = () => {
        iziToast.error({
        message: "{{session('error')}}",
        position: 'topRight',
    })
    }
  </script>
  @endif
  <div id="app" style="width: 100%">
    <main class="container-fluid">
      <div class="row align-items-center justify-content-center">
        <div class="col-md-7 col-lg-6 px-lg-4 px-xl-8 d-flex flex-column vh-100 py-6">

          <!-- Brand -->
          <a class="navbar-brand mb-auto" href="/">
            <img src="/massets/img/logo.png"
              class="navbar-brand-img logo-light logo-large" alt="..." width="125" height="25">
            <img src="/massets/img/logo.png"
              class="navbar-brand-img logo-dark logo-large" alt="..." width="125" height="25">
          </a>
          @yield('content')
        </div>

        <div class="col-md-5 col-lg-6 d-none d-lg-block">

          <!-- Image -->
          <div class="bg-size-cover bg-position-center bg-repeat-no-repeat overlay overlay-dark overlay-50 vh-100 me-n4"
            style="background-image: url({{asset('/assets/images/covers/sign-up-cover.jpg')}});">
          </div>
        </div>
      </div> <!-- / .row -->
    </main> <!-- / main -->
  </div>
  <!-- JAVASCRIPT-->
  <script src="{{asset('/assets/js/theme.bundle.js')}}"></script>
  <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
  <script src="{{asset('/assets/js/app.js')}}"></script>
</body>

</html>