@extends('layouts.install')

@section('content')

<div>
  <!-- Title -->
  <h1 class="mb-4">
    Zincvault Installer
  </h1>

  <div class="alert alert-danger" id="error" style="display: none"></div>
  <div class="alert alert-success" id="success" style="display: none"></div>
  <!-- Form -->
  <form method="POST" action="{{route('install.process_second')}}" id="installSecond">
    @csrf
    <div class="row mt-5">
      <!-- Subtitle -->
      <h3 class="mt-5">
        Administrator Configuration
      </h3>
      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Name
          </label>

          <!-- Input -->
          <input type="text" name="name" class="form-control" placeholder="eg. smtp" value="Adminstrator">
        </div>
      </div>
      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Email
          </label>

          <!-- Input -->
          <input type="email" name="email" class="form-control" placeholder="support@youremail.com">
        </div>
      </div>
      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Username
          </label>

          <!-- Input -->
          <input type="text" name="username" class="form-control">
        </div>
      </div>

      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Password
          </label>

          <!-- Input -->
          <input type="password" class="form-control" name="password">
        </div>
      </div>
    </div>
    <div class="row">
      <!-- Subtitle -->
      <h3 class="mt-5">
        Site Settings
      </h3>
      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Site Name
          </label>
          <!-- Input -->
          <input type="text" class="form-control" name="site_name" placeholder="eg Zinc Banking">
        </div>
      </div>

      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Site Url
          </label>

          <!-- Input -->
          <input type="text" class="form-control" name="site_url" placeholder="eg https://sitename.com">
        </div>
      </div>

      <div class="col-lg-6">
        <div class="mb-4">

          <!-- Label -->
          <label class="form-label">
            Site Email
          </label>

          <!-- Input -->
          <input type="text" class="form-control" name="site_email" placeholder="eg username@sitename.com">
        </div>
      </div>

    </div> <!-- / .row -->
    <button id="loading" class="btn btn-primary" type="button" disabled style="display: none">
      <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
      <span class="sr-only">Loading...</span>
    </button>
    <!-- Button -->
    <button type="text" id="done" class="btn btn-primary mt-3">
      Submit
    </button>
  </form>
</div>

<div class="mt-15">
</div>
@endsection