<form method="post" action="{{ route('admin.change-transaction-status', $transaction->txn_id) }}" x-data="{status: @js($transaction->status)}">
    @csrf
    <x-utilities.modal id="edit_status" title="Change Transaction Status">
        <div class="mb-3">
            <label class="form-label">Status</label>
            <x-form.select class="form-select" required name="status" x-model="status">
                <option value="successful" @selected($transaction->status=='successful')>Successful</option>
                <option value="pending" @selected($transaction->status=='pending')>Pending</option>
                <option value="cancelled" @selected($transaction->status=='cancelled')>Cancelled</option>
                <option value="rejected" @selected($transaction->status=='rejected')>Rejected</option>
            </x-form.select>
        </div>

        <div class="mb-3" x-show="status==='rejected'">
            <label class="form-label">Rejection Reason</label>
            <x-form.textarea class="form-control" name="reject_reason">{{ old('reason', $transaction->reject_reason) }}</x-form.textarea>
        </div>

        <x-slot:footer>
            <button type="submit" class="btn btn-primary">Change Transaction Status</button>
        </x-slot:footer>
    </x-utilities.modal>
</form>