@props(['name', 'old' => false, 'disabled' => false])
<select @disabled($disabled) name="{{ $name }}" {{ $attributes->merge([
    'class' => $errors->has($name) ? 'is-invalid': '',
    ]) 
    
}}
>
@if($old && old($name))
<option value="{{ old($name) }}" selected>{{ old($name) }}</option>
@endif
    {{ $slot }}
</select>

@error($name)
<div class="invalid-feedback text-danger d-block">
    {{ $message }}
</div>
@enderror