<x-layouts.auth title="Reset Password">
    <x-slot:subtitle>
      Create a super memorable but strong password.
    </x-slot:subtitle>
  
    <form method="POST" action="{{ route('password.update') }}">
      @csrf
      <input type="hidden" name="token" value="{{ $token }}">
      <div class="form-group">
        
        <div class="form-label-group">
          <label class="form-label" for="default-01">Email Address</label>
        </div>
        
        <input type="email" name="email" placeholder="username@email.com"
          class="@error('email') is-invalid @enderror form-control form-control-lg" required=""
          value="{{ old('email') ?? request('email') }}">
        
        @error('email')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
  
      </div>
  
      <div class="form-group">
        
        <div class="form-label-group">
          <label class="form-label" for="default-01">Password</label>
        </div>
        
        <input type="password" name="password" class="@error('password') is-invalid @enderror form-control form-control-lg" required="">
        
        @error('password')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
  
      </div>
  
  
      <div class="form-group">
        
        <div class="form-label-group">
          <label class="form-label" for="default-01">Password</label>
        </div>
        
        <input type="password" name="password_confirmation" class="@error('password_confirmation') is-invalid @enderror form-control form-control-lg" required="">
        
        @error('password_confirmation')
        <span class="invalid-feedback" role="alert">
          <strong>{{ $message }}</strong>
        </span>
        @enderror
  
      </div>
  
  
      <div class="form-group">
        <button class="btn btn-lg btn-primary btn-block" name="reset" type="submit">Reset
          Password</button>
  
      </div>
    </form>
  </x-layouts.auth>