@extends('includes.adminlayout')

@section('content')
<div class="container">
    <form method="POST">

        @csrf
        <!-- Card -->
        <div class="card border-0 scroll-mt-3">
            <div class="card-header">
                <h2 class="h3 mb-0"> Credit/Debit User</h2>
            </div>
            <div class="card-body">
                <div class="col-lg-12 mb-4">
                    <label class="form-label">Account Number</label>
                    <x-form.input type="text" class="form-control" name="account_number" :old="true" />
                </div>
                <div class="row mb-4">
                    <div class="col-lg mt-4">
                        <label class="form-label">Credit/Debit</label>
                        <x-form.select name="alert_type" class="form-select" :old="true">
                            <option value="">Select One</option>
                            <option value="credit">Credit</option>
                            <option value="debit">Debit</option>
                        </x-form.select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg mt-4">
                        <label class="form-label">Amount </label>
                        <x-form.input type="number" class="form-control" name="amount" :old="true" />
                    </div>
                    <div class="col-lg mt-4">
                        <label class="form-label">Date</label>
                        <x-form.input type="date" class="form-control" name="date" value="{{ now()->format('Y-m-d') }}" :old="true" />
                    </div>
                </div>
                <div class="col-lg-12 mt-4">
                    <label class="form-label">Note</label>
                    <x-form.textarea name="note" cols="2" rows="3" class="form-control">{{ old('note') }}</x-form.textarea>
                </div>
                <div class="form-check mt-4">
                    <input type="checkbox" class="form-check-input" name="send_email">
                    <label class="form-label" for="flexCheckDefault">
                        Send User Email Notification
                    </label>
                </div>
                <div class="d-flex justify-content-end mt-5">
                    <button type="submit" class="btn btn-primary">Send Transaction</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection