@extends('includes.adminlayout')
@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <h3 class="text-center">Card Details</h3>
            <hr>
            <form method="POST" x-data="{status: @js($card->status)}">
                @csrf
                <div class="row">

                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Holder Name</label>
                        <x-form.input type="text" name="holder_name" class="form-control" value="{{ old('holder_name', $card->holder_name) }}" />
                    </div>

                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12" x-data="{number: @js(old('number', $card->number))}">
                        <label class="form-label">Card Number</label>
                        <x-form.input name="number_display" type="text" class="form-control" x-model="number" x-mask="9999-9999-9999-9999" />
                        @error('number')
                            <div class="invalid-feedback d-block">
                                {{ $message }}
                            </div>
                        @enderror
                        <input name="number" type="hidden" class="form-control" :value="number.replace(/-/g, '')" />
                        
                    </div>

                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Card Type</label>
                        <x-form.select name="type" class="form-select">
                            <option value="">Select a card type</option>
                            <option value="visa" @selected(old('type', $card->type)=='visa')>Visa</option>
                            <option value="visa" @selected(old('type', $card->type)=='mastercard')>Mastercard</option>
                        </x-form.select>
                    </div>
                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Card Function </label>
                        <x-form.select name="function" class="form-select">
                            <option value="">Select one</option>
                            <option value="credit" @selected(old('function', $card->function)=='credit')>Credit</option>
                            <option value="debit" @selected(old('function', $card->function)=='debit')>Debit</option>
                        </x-form.select>
                    </div>
                    
                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Expiry</label>
                        <x-form.input type="date" name="expiry" class="form-control" value="{{ old('expiry', $card->expiry->format('Y-m-d')) }}" />
                    </div>
                    
                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">CVV</label>
                        <x-form.input name="cvv" class="form-control" value="{{ old('cvv', $card->cvv) }}" maxlength="3" />
                    </div>

                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Card Pin</label>
                        <x-form.input name="pin" class="form-control" value="{{ old('pin', $card->pin) }}" maxlength="4" />
                    </div>

                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Status</label>
                        <x-form.select name="status" class="form-select" x-model="status">
                            <option value="">Select a card type</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                        </x-form.select>
                    </div>

                    <div class="mb-3 col-md-6 col-xl-4 mb-5 col-sm-12">
                        <label class="form-label">Comment</label>
                        <x-form.input name="comment" class="form-control" value="{{ old('comment', $card->request->comment) }}" maxlength="3" />
                    </div>

                    <div class="mb-3 col-12 mb-5" x-show="status=='rejected'" x-cloak>
                        <label class="form-label">Reject Reason</label>
                        <x-form.textarea name="reject_reason" class="form-control" rows="4">{{ old('reject_reason', $card->request->reject_reason) }}</x-form.textarea>
                    </div>

                    <div class="mb-3 col-12 d-flex mb-5 justify-content-end">
                        <a class="btn btn-danger mx-5" href="{{ route('admin.delete-card', $card->id) }}">Delete</a>
                        <button class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection