<form method="POST">
    @csrf
    <div class="modal-account__right tab-content">
        <div class="modal-account__pane tab-pane show active" id="accountDetails">

            <div class="row row--md">
                <div class="col-md-6 form-group form-group--lg">
                    <label class="form-label form-label--sm text-primary">Amount ({{ $user->details->currency
                        }})</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">{{ $user->details->currency }}</span>
                        </div>
                        <x-form.input class="input" type="number" name="amount" placeholder="Eg 5000" :old="true"
                            required />
                    </div>
                </div>

                <div class="col-md-6 form-group form-group--lg">
                    <label class="form-label form-label--sm">Beneficiary Account Name</label>
                    <div class="input-group">
                        <x-form.input class="input" name="beneficiary_name" placeholder="Beneficiary Name" :old="true"
                            required />
                    </div>
                </div>
                <div class="col-md-6 form-group form-group--lg">
                    <label class="form-label form-label--sm">Beneficiary Account Number</label>
                    <div class="input-group">
                        <x-form.input name="beneficiary_account_number" class="input" required :old="true"
                            placeholder="Beneficiary Account Number" />
                    </div>
                </div>

                <div class="col-md-6 form-group form-group--lg">
                    <label class="form-label form-label--sm">Receiving Bank Name</label>
                    <div class="input-group">
                        <x-form.input class="input" type="text" name="receiving_bank" :old="true"
                            placeholder="Bank Name" />
                    </div>
                </div>

                <div class="col-md-6 form-group form-group--lg">
                    <label class="form-label form-label--sm">Beneficiary Email Address</label>
                    <div class="input-group">
                        <x-form.input class="input" type="email" name="beneficiary_email" :old="true"
                            placeholder="Enter Beneficiary Email" />
                    </div>
                </div>

                <div class="col-md-6 form-group form-group--lg mb-5">
                    <label class="form-label form-label--sm">Select Account Type</label>
                    <div class="input-group input-group--append">
                        <x-form.select class="input js-input-select input--fluid" name="account_type" :old="true">
                            <option value="">Select Account Type </option>
                            <option>Savings Account</option>
                            <option>Current Account</option>
                            <option>Checking Account</option>
                            <option>Fixed Deposit</option>
                            <option>Non Resident Account</option>
                            <option>Online Banking</option>
                            <option>Joint Account</option>
                            <option>Domiciliary Account</option>
                        </x-form.select>

                        <span class="input-group__arrow">
                            <svg class="icon-icon-keyboard-down">
                                <use xlink:href="#icon-keyboard-down"></use>
                            </svg>
                        </span>
                    </div>
                </div>
                <div class="col-md-12 form-group form-group--lg">
                    <label class="form-label form-label--sm">Select Receiving Country</label>
                    <div class="input-group">
                        <x-form.select class="input js-input-select input--fluid" name="receiving_country" :old="true">
                            <option value="">Select Country </option>
                            @include('partials.register.countries')
                        </x-form.select>

                        <span class="input-group__arrow">
                            <svg class="icon-icon-keyboard-down">
                                <use xlink:href="#icon-keyboard-down"></use>
                            </svg>
                        </span>
                    </div>
                </div>

                <div class="col-12 col-lg-12 form-group form-group--lg">
                    <label class="form-label form-label--sm">Narration/Purpose</label>
                    <div class="input-group">
                        <x-form.textarea class="input" cols=4 name="description" placeholder="Funds Description"
                            required>{{ old('description') }}</x-form.textarea>
                    </div>
                </div>

                <h6 class="text-primary">Account Owner Authorization:</h6>

                <div class="col-12 col-lg-12 form-group form-group--lg mb-0 mt-4">
                    <label class="form-label form-label--sm">Transfer Pin</label>
                    <div class="input-group">
                        <x-form.input :old="true" class="input" type="number" name="pin" placeholder="Enter Your Pin" />
                    </div>
                    <button class="mt-4 w-100 my-btn" type="submit"><span class="button__text">Transfer
                        </span><span class="ml-1"></span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>