@php

    if($transaction->state_level == 0){
        $beginprogress = '0%';
        $endprogress = '0%';
    }
    
    if($transaction->state_level == 1){
        $beginprogress = '0%';
        $endprogress = '30%';
    }
    
    if($transaction->state_level == 2){
        $beginprogress = '30%';
        $endprogress = '60%';
    }
@endphp
  <div 
    x-data="{email_button_text: 'Didn\'t receive the email?'}"
    @otp-sent.window="email_button_text='Sent'"
>

<style>

/* Styles for the progress bar container */
.myProgress-bars {
  width: 100%;
  height: 20px;
  background-color: #f0f0f0;
  margin-bottom: 15px;
  border-radius: 5px;
  overflow: hidden;
}

/* Styles for the progress bar */
.my-Progress {
  height: 100%;
  background-color: darkgreen;
  border-radius: 5px;
  color: #fff;
  text-align: center;
  line-height: 20px; /* Vertically center the text */
  animation: progressAnimation 5s ease-in-out forwards;
}

/* Animation keyframes for the progress bar */
@keyframes progressAnimation {
  0% {
    width: {{$beginprogress}};
  }
  100% {
    width: {{$endprogress}};
  }
}

  </style>
    <form wire:submit.prevent="confirmTransaction({{$transaction->id}})" method="post" 
        >
        <x-utilities.modal id="{{$transaction->id}}" title="Complete Transaction">
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xl-12">
                <label for="progress" class="form-label">Transaction Progress</label>
                    <div class="myProgress-bars">
                      <div class="my-Progress" id="my-Progress" data-value="{{$beginprogress}}">
                          {{ $endprogress }}
                    </div>
                    </div>
                    </div>
                {{--<!--<div class="col-md-12 col-sm-12 col-xl-12 mx-auto mb-5">-->
                <!--    <label for="otp" class="form-label">OTP</label>-->
                <!--    <input type="text" class="@if(session('otp'))is-valid @endif form-control @error('otp')is-invalid-->
                <!--        @enderror" wire:model="otp">-->
                <!--    @error('otp')-->
                <!--    <span class="invalid-feedback" role="alert">-->
                <!--        <strong>{{ $message }}</strong>-->
                <!--    </span>-->
                <!--    @enderror-->
                <!--</div>-->--}}

                @if($transaction->state_level == 0)
                <div class="col-md-12 col-sm-12 col-xl-12" id="tax_code_level">
                    <label for="tax_code" class="form-label">TAX Code</label>
                    <input type="text" class=" @if(session('tax'))is-valid @endif form-control
                        @error('tax_code')is-invalid @enderror" wire:model="tax_code">
                    @error('tax_code')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                @endif
                @if($transaction->state_level == 1)
                <div class="col-md-12 col-sm-12 col-xl-12" id="imf_code_level">
                    <label for="tax_code" class="form-label">IMF Code</label>
                    <input type="text" class=" @if(session('imf'))is-valid @endif form-control
                        @error('imf_code')is-invalid @enderror" wire:model="imf_code">
                    @error('imf_code')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                @endif
                @if($transaction->state_level == 2)
                <div class="col-md-12 col-sm-12 col-xl-12 mb-5" id="cot_code_level">
                    <label for="tac_code" class="form-label">COT Code</label>
                    <input type="text" class="@if(session('tac'))is-valid @endif form-control
                        @error('tac_code')is-invalid @enderror" wire:model="tac_code">
                    @error('tac_code')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                @endif
                
            </div>
            <x-slot:footer>
                <x-utilities.submit-button 
                target="confirmTransaction({{$transaction->id}})" 
                loading-button-text="Confirming..." 
                button-text="Confirm"
                />
            </x-slot:footer>
        </form>
        {{--<!--<span
            class="fw-bold badge text-bg-info" role="button" aria-disabled="true"
            wire:click="$emit('sendOTP')" x-text="email_button_text"
            @click="email_button_text='Sending...'"
            style="border: 0"
        >
        <!--</span> -->--}}
        </x-utilities.modal>
    <script>
        document.addEventListener('livewire:load', () => {
            Livewire.on("OTPSent", () => {
                iziToast.success({
                    icon: 'material-icons',
                    iconText: 'check_circle',
                    title: "Success",
                    message: "OTP Successfully Sent to Your Email",
                    position: 'topRight'
                })
            })
            
            window.addEventListener('transfer-confirmed', () => {
                Livewire.emit('updated')
                $('#{{$transaction->id}}').modal('hide')
                iziToast.success({
                    icon: 'material-icons',
                    iconText: 'check_circle',
                    message: "Transaction Confirmed Successfully",
                    position: 'topRight'
                })
            })
        })
    </script>
</div>