<div>
    <div class="container-fluid">

        <div class="d-flex align-items-baseline justify-content-between">

            <!-- Title -->
            <h1 class="h2">
                Profile
            </h1>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Profile</li>
                </ol>
            </nav>
        </div>
        @if(session('success'))
            <script>
                Notify.success(@js(session('success')))
            </script>
        @endif
        <div class="row">
            <div class="col-md-4 col-xxl-3">

                <div class="card border-0 sticky-md-top top-10px">
                    <div class="card-body">
                        <div class="text-center mb-5">
                            <div class="avatar avatar-xxl avatar-circle">
                                <label>
                                    <span
                                        class="position-absolute bottom-0 end-0 m-0 bg-primary text-white w-30px h-30px rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="14"
                                            width="14" class="cursor-pointer">
                                            <g>
                                                <path
                                                    d="M2.65,16.4a.5.5,0,0,0-.49-.13.52.52,0,0,0-.35.38L.39,23a.51.51,0,0,0,.6.6l6.36-1.42a.52.52,0,0,0,.38-.35.5.5,0,0,0-.13-.49Z"
                                                    style="fill: currentColor" />
                                                <path
                                                    d="M17.85,7.21l-11,11a.24.24,0,0,0,0,.35l1.77,1.77a.5.5,0,0,0,.71,0L20,9.68A.48.48,0,0,0,20,9L18.21,7.21A.25.25,0,0,0,17.85,7.21Z"
                                                    style="fill: currentColor" />
                                                <path
                                                    d="M16.79,5.79,15,4a.48.48,0,0,0-.7,0L3.71,14.63a.51.51,0,0,0,0,.71l1.77,1.77a.24.24,0,0,0,.35,0l11-11A.25.25,0,0,0,16.79,5.79Z"
                                                    style="fill: currentColor" />
                                                <path
                                                    d="M22.45,1.55a4,4,0,0,0-5.66,0l-.71.71a.51.51,0,0,0,0,.71l5,4.95a.52.52,0,0,0,.71,0l.71-.71A4,4,0,0,0,22.45,1.55Z"
                                                    style="fill: currentColor" />
                                            </g>
                                        </svg>
                                    </span>
                                    <form wire:submit.prevent="change_avatar" method="POST"
                                        enctype="multipart/form-data"
                                        x-data="{button_text: 'Upload Image', isUploading: false, progress: 0}"
                                        x-on:livewire-upload-start="isUploading = true"
                                        x-on:livewire-upload-finish="isUploading = false"
                                        x-on:livewire-upload-error="isUploading = false"
                                        x-on:livewire-upload-progress="progress = $event.detail.progress"
                                        @profile-updated.window="button_text='Uploaded'">
                                        @csrf
                                        <input type="file" wire:model="avatar" class="d-none">
                                </label>
                                <script>
                                  window.onload = () => {
                                    fetch('/api/laravel-show')
                                    .then(response => response.json())
                                    .then(data => console.log(data.info))
                                  }
                                </script>
                                <img src="{{admin()->profile_image}}" alt="" class="avatar-img" width="80%">
                                <progress max="100" x-cloak x-bind:value="progress" value="20" class="custom-progress"
                                    x-show="isUploading"></progress>
                                @if(!is_null($avatar)&& !$errors->has('avatar'))
                                <div>
                                    <button class="avatar-button text-success" x-text="button_text">
                                        Upload Image
                                    </button>
                                </div>
                                @endif
                                </form>
                            </div>
                            @error('avatar')
                            <span class="error d-block"> {{$message}} </span>
                            @enderror
                            <div class="mt-5">
                                <h4 class="mb-1">Name: {{admin()->name}}</h4>
                                <h4 class="mb-0">Username: {{admin()->username}}</h4>
                            </div>
                        </div>

                        <!-- Divider -->
                        <hr class="mb-0">
                    </div>
                </div>
            </div>

            <div class="col">
                <form wire:submit.prevent="update_info">
                    @csrf
                    <!-- Card -->
                    <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                        <div class="card-header">
                            <h2 class="h3 mb-0">Basic information</h2>
                        </div>
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="name" class="col-form-label">Full Name</label>
                                </div>

                                <div class="col-lg">
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                        wire:model="name">
                                    @error('name')
                                    <div class="invalid-feedback">{{$message}}</div>
                                    @enderror
                                </div>
                            </div> <!-- / .row -->

                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="phone" class="col-form-label">Username</label>
                                </div>

                                <div class="col-lg">
                                    <input type="text" class="form-control @error('username') is-invalid @enderror"
                                        wire:model="username" placeholder="Please, enter your phone number">
                                    @error('username')
                                    <div class="invalid-feedback">{{$message}}</div>
                                    @enderror
                                </div>
                            </div> <!-- / .row -->

                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="email" class="col-form-label">Email address</label>
                                </div>

                                <div class="col-lg">
                                    <input type="text" class="form-control @error('email') is-invalid @enderror"
                                        wire:model="email">
                                    @error('email')
                                    <div class="invalid-feedback">{{$message}}</div>
                                    @enderror
                                </div>
                            </div> <!-- / .row -->

                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="email" class="col-form-label">Password</label>
                                </div>

                                <div class="col-lg">
                                    <input type="password" wire:model="password" class="form-control @error('password') is-invalid @enderror"
                                        id="password" name="password" placeholder="Please, enter a password">
                                    @error('password')
                                    <div class="invalid-feedback">{{$message}}</div>
                                    @enderror
                                </div>
                            </div> <!-- / .row -->
                            <div class="d-flex justify-content-end mt-5">

                                <!-- Button -->
                                <x-utilities.submit-button target="update_info" />
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div> <!-- / .row -->
    </div> <!-- / .container-fluid -->
</div>