<div>
    <div class="container">
        <div class="d-flex align-items-baseline justify-content-between">

            <!-- Title -->
            <h1 class="h2">
                Generate Transaction
            </h1>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Generate Transaction</li>
                </ol>
            </nav>
        </div>
        <div class="card">
            <div class="card-body">
                <form wire:submit.prevent="generateTransaction">
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Number of Transaction to Generate</label>
                                <input type="number"
                                    class="form-control @error('transaction_number') is-invalid @enderror"
                                    wire:model="transaction_number">
                                @error('transaction_number')
                                <span class="fw-bold invalid-feedback">
                                    {{$message}}
                                </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row mb-5">
                      <div class="col-md-6 mb-5 mx-auto">
                        <div class="form-group">
                          <label class="form-label">Transaction Type</label>
                          <select class="form-select @error('transaction_type') is-invalid @enderror"
                              wire:model="transaction_type">
                              <option value="" selected>Select One</option>
                              <option value='1'>Local Transfer</option>
                              <option value='2'>International Transfer</option>
                          </select>
                          @error('transaction_type')
                          <span class="fw-bold invalid-feedback">
                              {{$message}}
                          </span>
                          @enderror
                      </div>
                    </div>
                      <div class="col-md-6 mb-5 mx-auto">
                            <div class="form-group">
                                <label class="form-label">Username of user who you would like to generate this
                                    transaction for</label>
                                <input type="text" class="form-control @error('username') is-invalid @enderror"
                                    wire:model="username">
                                @error('username')
                                <span class="fw-bold invalid-feedback">
                                    {{$message}}
                                </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="text-center" id="exchangeLoader" style="display: none">
                        <span class="spinner-grow text-primary" role="status" align="center"></span>
                    </div>
                    <div class="text-center">
                        <x-utilities.submit-button target="generateTransaction" button-text="Generate Transaction"
                            loading-button-text="Generating..." />
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('livewire:load', () => {
            Livewire.on('generated', (number) => {
            Notify.success(number > 1 ? `${number} transactions generated successfully`: `${number} transaction generated successfully`)
        })  
        })
    </script>
</div>