<form action="{{ route('admin.edit-transaction', $transaction->txn_id) }} " method="post" id="transactionTimeForm">
    @csrf
    <x-utilities.modal id="edit_transaction" :$title>
        <div class="mb-3">
            <label class="form-label" for="transaction_date">
                Transaction Date
            </label>
            <input name="transaction_date" type="datetime" class="form-control" value="{{ $transaction->date }}"
                id="transaction_date">
        </div>
        <x-slot:footer>
            <button id="done" type="submit" class="btn btn-primary">{{$title}}</button>
            <button id="loading" class="btn btn-primary" type="button" disabled style="display: none">
                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                <span class="sr-only">Loading...</span>
            </button>
        </x-slot:footer>
    </x-utilities.modal>
</form>

<style>
    .flatpickr-time,
    .flatpickr-am-pm {
        color: black !important;
        background: white !important;
    }

    .flatpickr-time:hover,
    .flatpickr-am-pm:hover,
    .numInput:hover {
        color: black !important;
        background: white !important;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.13/flatpickr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.13/flatpickr.min.css" />
<script>
$("#transaction_date").flatpickr({
    enableTime: true,
    altInput: true,
    dateFormat: "Y-m-d H:i",
    theme: "dark"
})
$('#transactionTimeForm').submit(function (e) {
    e.preventDefault()
    $('#done').hide()
    $('#loading').show()
    var formData = $('#transactionTimeForm').serializeArray();
    $.ajax({
        type: "post",
        url: "{{ route('admin.edit-transaction', $transaction->txn_id) }}",
        data: formData,
        dataType: "json",
        success: (response) => {
            Livewire.emit('getLatestDate')
            if (response.success) {
                $('#edit_transaction').modal('hide')
                Notify.success(response.success)

            }
            $('#done').show()
            $('#loading').hide()
        },
        error: (response) => {
            Notify.error('Something webt wrong. Please, try again later.')
            $('#done').show()
            $('#loading').hide()
            console.log(response)
        }
    })
})
</script>