@extends('includes.adminlayout')
@section('content')

    <h1 class="h2 mx-5">
        Create New User
    </h1>
    <main>
        <div class="card mx-2">
            <div class="my-auto">
                <form method="POST" enctype="multipart/form-data">
                    @csrf
                    <!-- Card -->
                <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                    <div class="card-header">
                        <h2 class="h3 mb-0">Basic information</h2>
                    </div>

                    <div class="row card-body">
                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Full Name</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="name" :old="true" placeholder="Enter name" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Phone</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="phone_number" :old="true" placeholder="Enter phone number" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Email address</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="email" :old="true" placeholder="Enter email" type="email" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Username</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="username" :old="true" placeholder="Enter username" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Pin</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="pin" :old="true" type="text" maxlength="5" placeholder="Enter 5-digit pin"  />
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Country </label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select :old="true" name="country" class="form-select" :old="true">
                                        <option value="">Select Country</option>
                                        @include('partials.register.countries')
                                    </x-form.select>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Gender </label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select :old="true" name="gender" class="form-select" :old="true">
                                        <option value="">Select Gender</option>
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Address Line</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="address" :old="true" placeholder="Please, enter an address" />
                            </div>

                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Date of Birth</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input type="date" class="form-control" name="date_of_birth" :old="true" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Account Type </label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select :old="true" name="account_type" class="form-select">
                                        <option value="">Choose Account Type</option>
                                        <option value="savings">Savings</option>
                                        <option value="current">Current</option>
                                        <option value="checking">Checking</option>
                                        <option value="fixed deposit">Fixed Deposit</option>
                                        <option value="non resident">Non-Resident</option>
                                        <option value="online banking">Online Banking</option>
                                        <option value="joint">Joint Account</option>
                                        <option value="domiciliary">Domiciliary Account</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Marital Status</label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select :old="true" name="marital_status" class="form-select">
                                        <option value="">Change Marital Status</option>
                                        <option value="single">Single
                                        </option>
                                        <option value="married">Married</option>
                                        <option value="divorced">Divorced</option>
                                        <option value="widowed">Widowed</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Occupation</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="occupation" :old="true" placeholder="Enter Occupation" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Password</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="password" :old="true" placeholder="********" type="password" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Retype Password</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input class="form-control" name="password_confirmation" :old="true" placeholder="********" type="password" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">Currency</label>
                            </div>

                            <div class="col-lg">
                                <div class="mb-4">
                                    <x-form.select :old="true" name="currency" class="form-select">
                                        <option value="">Select Currency</option>
                                        
                                        <option value="$">Dollar </option>
                                        <option value="£">Pound </option>
                                        <option value="€">Euro</option>
                                    </x-form.select>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="col-lg-3">
                                <label class="col-form-label">SSN/TIN</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input type="number" class="form-control" name="ssn" :old="true" placeholder="Enter SSN/TIN"  />
                            </div>
                        </div>

                        <div class="col-md-12 mb-5">
                            <div class="col-lg-3">
                                <label class="col-form-label">Profile Photo</label>
                            </div>

                            <div class="col-lg">
                                <x-form.input type="file" class="form-control" name="avatar" />
                            </div>
                        </div>
                        <div class="form-check mx-5">
                            <input type="checkbox" class="form-check-input" name="send_email">
                            <label class="form-label">
                                Send User Welcome Email Notification
                            </label>
                        </div>

                        <div class="form-check mx-5">
                            <input type="checkbox" class="form-check-input" name="verify_email">
                            <label class="form-label">
                                Automatically verify user's email?
                            </label>
                        </div>
                        <div class="d-flex justify-content-end mt-5">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </main>
@endsection