@extends('includes.adminlayout')
@section('title', 'Transaction - '.$transaction->txn_id)
@section('content')
<main>
    <div class="container">

        <div class="card">
            <div class="card-body">

                <h3 class="text-center">Transaction - {{ $transaction->txn_id }} </h3>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th>Item</th>
                                <th>Detail</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            <tr class="text-center">
                                <th colspan="2">Amount</th>
                            </tr>
                            <tr>
                                <th class="w-25">Transaction Type</th>
                                <td class="w-25">{{ ucfirst($transaction->transaction_type->value) }}</td>
                            </tr>
                            <tr>
                                <th>Amount</th>
                                <td>{{ $transaction->total_amount }}</td>
                            </tr>
                            <tr>
                                <th>Alert Type</th>
                                <td> <span @class([ 'badge' , 'text-bg-success'=> $transaction->alert_type->isCredit(),
                                        'text-bg-danger' => $transaction->alert_type->isDebit(),
                                        ])
                                        >
                                        {{$transaction->alert_type}}
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <th>Description</th>
                                <td>{{ $transaction->description }}</td>
                            </tr>

                            @if($transaction->details)

                            <tr class="text-center">
                                <th colspan="2">Transaction Details</th>
                            </tr>

                            @foreach ($transaction->details as $detail => $value)
                            @if($detail !== 'total_amount' && $detail !== 'total_amount' && $value)
                            <tr>
                                <th>{{ convertText($detail) }}</th>
                                <td>{{ $value }}</td>
                            </tr>
                            @endif
                            @endforeach
                            @endif

                            <tr class="text-center">
                                <th colspan="2">Others</th>
                            </tr>

                            <tr>
                                <th>Note</th>
                                <td>{{ $transaction->narration }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <span @class([ 'badge' , 
                                        'bg-success'=> $transaction->status==='successful',
                                        'bg-info' => $transaction->status=='pending',
                                        'bg-warning' => $transaction->status=='cancelled',
                                        'bg-danger' => $transaction->status=='rejected',
                                        'bg-secondary' => $transaction->status=='expired',
                                        ])>
                                        {{ $transaction->status }}
                                    </span>
                                </td>
                            </tr>
                            @livewire('utils.transaction-time', [
                            'transaction' => $transaction->id,
                            'transaction_date' => $transaction->date,
                            ])
                        </tbody>
                    </table>

                    <table class="table">
                        <tr>
                            <td class="text-center fw-bold">Edit Transaction Date<br>
                                <i style="color: #00bac7" data-bs-toggle="modal" data-bs-target="#edit_transaction"
                                    id="edit" class="material-icons p-5 cursor-pointer">edit</i>
                            </td>
                            <td class="text-center fw-bold">Change Transaction Status<br>
                                <i style="color: #00bac7" data-bs-toggle="modal" data-bs-target="#edit_status"
                                    class="material-icons p-5 cursor-pointer">check_circle</i>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>
@include('includes.admin.transaction-modal')
@include('includes.admin.transaction-status-modal')
@endsection