

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Manage Card Requests
    </h1>

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            User
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Card Type
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Card Function
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Comment
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            
                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                <?php $__empty_1 = true; $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('admin.user-edit', $card->user->id)); ?>" target="_blank"><?php echo e($card->user->name); ?></a>
                                    </td>

                                    <td><span><?php echo e(ucfirst($card->type)); ?></span></td>
                                    <td><span><?php echo e(ucfirst($card->function)); ?></span></td>
                                    <td><span><?php echo e(ucfirst($card->request->comment)); ?></span></td>
                                    <td class="date"><span><?php echo e($card->created_at); ?></span></td>

                                    <td class="date">
                                        <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'badge' , 'bg-success'=> $card->status=='approved',
                                            'bg-warning' => $card->status=='pending',
                                            'bg-danger' => $card->status=='rejected',
                                            ]) ?>">
                                            <?php echo e($card->status); ?>

                                        </span>
                                    </td>

                                    <td class="date">
                                        <a href="<?php echo e(route('admin.view-card', $card->id)); ?>" class="badge bg-primary">View</a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" align="center" class="fw-bold">No international request yet</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="mt-6 p-4">
                <?php echo e($cards->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('includes.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jwmhizws/eastaccessfinance.com/resources/views/admin/cards/all.blade.php ENDPATH**/ ?>