<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta content="Webinning" name="author" />
  <link rel="stylesheet" href="/assets/css/theme.bundle.css" id="stylesheetLTR" />
  <link rel="stylesheet" href="/assets/css/theme.rtl.bundle.css" id="stylesheetRTL" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link rel="preload" as="style"
    href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
  <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');"
    href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
  <script src="https://cdn.jsdelivr.net/npm/pace-js@latest/pace.min.js"></script>
  <link rel="stylesheet" href="<?php echo e(asset('/assets/css/flash.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('/assets/izitoast/dist/css/izitoast.min.css')); ?>" />
  <script src="<?php echo e(asset('/assets/izitoast/dist/js/izitoast.min.js')); ?>"></script>
  <script src="https://code.jquery.com/jquery-3.6.1.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script> <noscript>
    <link rel="stylesheet"
      href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
  </noscript>
  <script>
    // Theme switcher
        
            let themeSwitcher = document.getElementById('themeSwitcher');
        
            const getPreferredTheme = () => {
                if (localStorage.getItem('theme') != null) {
                    return localStorage.getItem('theme');
                }
        
                return document.documentElement.dataset.theme;
            };
        
            const setTheme = function (theme) {
                if (theme === 'auto' && window.matchMedia('(prefers-color-scheme: dark)').matches) {
                    document.documentElement.dataset.theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
                } else {
                    document.documentElement.dataset.theme = theme;
                }
        
                localStorage.setItem('theme', theme);
            };
        
            const showActiveTheme = theme => {
                const activeBtn = document.querySelector(`[data-theme-value="${theme}"]`);
        
                document.querySelectorAll('[data-theme-value]').forEach(element => {
                    element.classList.remove('active');
                });
        
                activeBtn && activeBtn.classList.add('active');
        
             // Set button if demo mode is enabled
                document.querySelectorAll('[data-theme-control="theme"]').forEach(element => {
                    if (element.value == theme) {
                        element.checked = true;
                    }
                });
            };
        
            function reloadPage() {
                window.location = window.location.pathname;
            }
        
        
            setTheme(getPreferredTheme());
        
            if(typeof themeSwitcher != 'undefined') {
                window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
                    if(localStorage.getItem('theme') != null) {
                        if (localStorage.getItem('theme') == 'auto') {
                            reloadPage();
                        }
                    }
                });
        
                window.addEventListener('load', () => {
                    showActiveTheme(getPreferredTheme());
                    
                    document.querySelectorAll('[data-theme-value]').forEach(element => {
                        element.addEventListener('click', () => {
                            const theme = element.getAttribute('data-theme-value');
        
                            localStorage.setItem('theme', theme);
                            reloadPage();
                        })
                    })
                });
            }
  </script>
          <script type="text/javascript">
            function googleTranslateElementInit() {
              new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
          }
        </script>
        <script type="text/javascript"
          src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
        </script> 
  <link rel="icon" href="<?php echo e(settings()->site_favicon); ?>" sizes="any" />
  <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(settings()->site_name); ?></title>
</head>

<body class="d-flex align-items-center bg-light-green">
  <main class="container-fluid">
    <div class="row align-items-center justify-content-center">
      <div class="col-md-7 col-lg-6 px-lg-4 px-xl-8 d-flex flex-column vh-100 py-6">
        <?php echo $__env->make('includes.general.brand', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="google_translate_element"></div>
        <?php echo $__env->yieldContent('content'); ?>
      </div>
    </div>
  </main>
  <script src="<?php echo e(asset('/assets/js/theme.bundle.js')); ?>"></script>
  <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
  <script src="<?php echo e(asset('/assets/js/app.js')); ?>"></script>
  <?php echo settings()->live_support; ?>

</body>

</html><?php /**PATH /home/consolac/universalinstant.org/resources/views/layouts/app.blade.php ENDPATH**/ ?>