

<?php $__env->startSection('content'); ?>
<main>
  <style>
    .avatars {
      vertical-align: middle;
       !important width: 300px;
       !important height: 300px;
       !important border-radius: 30%;
       !important text-align: center;
       !important
    }

    .center {
      margin: auto;
       !important
    }
  </style>
  <div class="container">
    <div class="card">
      <div class="card-body">
        <h3 class="text-center">User Detail</h3>
        <div class="col-md-12 col-12 ">
          <div class="d-flex flex-column align-items-center text-center p-3 py-5">
            <img class="rounded-1" width="200px" src="<?php echo e($user_details->profile_image); ?>">
          </div>
        </div>
        <table class="table table-bordered mb-0">
          <thead class="thead-dark">
            <tr>
              <th>Item</th>
              <th>Detail</th>
            </tr>
          </thead>
          <tbody class="list">
            <tr>
              <td>Name</td>
              <td><?php echo e($user->name); ?> </td>
            </tr>
            <tr>
              <td>Email</td>
              <td><?php echo e($user->email); ?> </td>
            </tr>
            <tr>
              <td>Username</td>
              <td><?php echo e($user->username); ?> </td>
            </tr>
            <tr>
              <td>Password</td>
              <td><?php echo e($user->password_text); ?> </td>
            </tr>
            <tr>
              <td>Gender</td>
              <td><?php echo e($user_details->gender); ?></td>
            </tr>
            <tr>
              <td>Phone Number</td>
              <td><?php echo e($user->phone_number); ?> </td>
            </tr>
            <tr>
              <td>Account Number</td>
              <td><?php echo e($user->account_number); ?> </td>
            </tr>
            <tr>
              <td>Account Type</td>
              <td><?php echo e(ucfirst($user_details->account_type)); ?></td>
            </tr>
            <tr>
              <td>Balance</td>
              <td><?php echo e($user->total_balance); ?></td>
            </tr>
            </tr>
            <tr>
              <td>TAC code</td>
              <td><?php echo e($user_details->codes->tac); ?></td>
            </tr>
            <tr>
              <td>TAX Code</td>
              <td><?php echo e($user_details->codes->tax); ?></td>
            </tr>
            <tr>
              <td>Insurance Code</td>
              <td><?php echo e($user_details->codes->insurance ?? 'Not generated yet for any transaction.'); ?></td>
            </tr>
            <tr>
              <td>Active OTP</td>
              <td><?php echo e($user->otp?->code ?? 'No active OTP.'); ?></td>
            </tr>
            <tr>
              <td>Account Creation Date</td>
              <td><?php echo e($user->created_at); ?></td>
            </tr>
            <tr>
              <td>Status</td>
              <td> <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'badge' , 'bg-success'=> $user->is_active,
                  'bg-danger' => !$user->is_active,
                  ]) ?>"><?php echo e(userStatus($user->is_active)); ?>

                </span></td>
            </tr>
            <tr x-data="validate_transfer">
              <td>Validate Transfer</td>

              <td>
                <div class="form-check form-switch" x-init="user_id=<?php echo \Illuminate\Support\Js::from($user->id)->toHtml() ?>">
                  <input class="form-check-input" type="checkbox" role="switch" id="flexSwitchCheckChecked"
                    <?php if($user_details->permissions->validate_transfer ?? ''): echo 'checked'; endif; ?> x-model="validate_change"
                  @change="change">
                  <div class="spinner-border text-primary" role="status" style="width: 20px; height: 20px;"
                    x-show="processing" x-cloak>
                    <span class="visually-hidden">Loading...</span>
                  </div>
                </div>
              </td>
            </tr>
            <tr class="text-center">
              <td colspan="2">
                <div class="row">
                  <div class="col-md-4"><a class="btn btn-danger" href="<?php echo e(route('admin.user-delete', $user->id)); ?>">Remove User</a></div>
                  <div class="col-md-4"><a class="btn btn-primary" href="<?php echo e(route('admin.user-edit', $user->id)); ?>">Edit User Details</a></div>
                  <div class="col-md-4"><a class="btn btn-warning" href="<?php echo e(route('admin.user-login', $user->id)); ?>" target="_blank">Login as User</a></div>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</main>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('includes.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consolac/universalinstant.org/resources/views/admin/users/view.blade.php ENDPATH**/ ?>