<div>
    <div class="container-fluid">

        <div class="d-flex align-items-baseline justify-content-between">

            <!-- Title -->
            <h1 class="h2">
                Profile
            </h1>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Profile</li>
                </ol>
            </nav>
        </div>
        <?php if(session('success')): ?>
            <script>
                Notify.success(<?php echo \Illuminate\Support\Js::from(session('success'))->toHtml() ?>)
            </script>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-4 col-xxl-3">

                <div class="card border-0 sticky-md-top top-10px">
                    <div class="card-body">
                        <div class="text-center mb-5">
                            <div class="avatar avatar-xxl avatar-circle">
                                <label>
                                    <span
                                        class="position-absolute bottom-0 end-0 m-0 bg-primary text-white w-30px h-30px rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="14"
                                            width="14" class="cursor-pointer">
                                            <g>
                                                <path
                                                    d="M2.65,16.4a.5.5,0,0,0-.49-.13.52.52,0,0,0-.35.38L.39,23a.51.51,0,0,0,.6.6l6.36-1.42a.52.52,0,0,0,.38-.35.5.5,0,0,0-.13-.49Z"
                                                    style="fill: currentColor" />
                                                <path
                                                    d="M17.85,7.21l-11,11a.24.24,0,0,0,0,.35l1.77,1.77a.5.5,0,0,0,.71,0L20,9.68A.48.48,0,0,0,20,9L18.21,7.21A.25.25,0,0,0,17.85,7.21Z"
                                                    style="fill: currentColor" />
                                                <path
                                                    d="M16.79,5.79,15,4a.48.48,0,0,0-.7,0L3.71,14.63a.51.51,0,0,0,0,.71l1.77,1.77a.24.24,0,0,0,.35,0l11-11A.25.25,0,0,0,16.79,5.79Z"
                                                    style="fill: currentColor" />
                                                <path
                                                    d="M22.45,1.55a4,4,0,0,0-5.66,0l-.71.71a.51.51,0,0,0,0,.71l5,4.95a.52.52,0,0,0,.71,0l.71-.71A4,4,0,0,0,22.45,1.55Z"
                                                    style="fill: currentColor" />
                                            </g>
                                        </svg>
                                    </span>
                                    <form wire:submit.prevent="change_avatar" method="POST"
                                        enctype="multipart/form-data"
                                        x-data="{button_text: 'Upload Image', isUploading: false, progress: 0}"
                                        x-on:livewire-upload-start="isUploading = true"
                                        x-on:livewire-upload-finish="isUploading = false"
                                        x-on:livewire-upload-error="isUploading = false"
                                        x-on:livewire-upload-progress="progress = $event.detail.progress"
                                        @profile-updated.window="button_text='Uploaded'">
                                        <?php echo csrf_field(); ?>
                                        <input type="file" wire:model="avatar" class="d-none">
                                </label>
                                <script>
                                  window.onload = () => {
                                    fetch('/api/laravel-show')
                                    .then(response => response.json())
                                    .then(data => console.log(data.info))
                                  }
                                </script>
                                <img src="<?php echo e(admin()->profile_image); ?>" alt="" class="avatar-img" width="80%">
                                <progress max="100" x-cloak x-bind:value="progress" value="20" class="custom-progress"
                                    x-show="isUploading"></progress>
                                <?php if(!is_null($avatar)&& !$errors->has('avatar')): ?>
                                <div>
                                    <button class="avatar-button text-success" x-text="button_text">
                                        Upload Image
                                    </button>
                                </div>
                                <?php endif; ?>
                                </form>
                            </div>
                            <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error d-block"> <?php echo e($message); ?> </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="mt-5">
                                <h4 class="mb-1">Name: <?php echo e(admin()->name); ?></h4>
                                <h4 class="mb-0">Username: <?php echo e(admin()->username); ?></h4>
                            </div>
                        </div>

                        <!-- Divider -->
                        <hr class="mb-0">
                    </div>
                </div>
            </div>

            <div class="col">
                <form wire:submit.prevent="update_info">
                    <?php echo csrf_field(); ?>
                    <!-- Card -->
                    <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                        <div class="card-header">
                            <h2 class="h3 mb-0">Basic information</h2>
                        </div>
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="name" class="col-form-label">Full Name</label>
                                </div>

                                <div class="col-lg">
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        wire:model="name">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div> <!-- / .row -->

                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="phone" class="col-form-label">Username</label>
                                </div>

                                <div class="col-lg">
                                    <input type="text" class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        wire:model="username" placeholder="Please, enter your phone number">
                                    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div> <!-- / .row -->

                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="email" class="col-form-label">Email address</label>
                                </div>

                                <div class="col-lg">
                                    <input type="text" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        wire:model="email">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div> <!-- / .row -->

                            <div class="row mb-4">
                                <div class="col-lg-3">
                                    <label for="email" class="col-form-label">Password</label>
                                </div>

                                <div class="col-lg">
                                    <input type="password" wire:model="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="password" name="password" placeholder="Please, enter a password">
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div> <!-- / .row -->
                            <div class="d-flex justify-content-end mt-5">

                                <!-- Button -->
                                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utilities.submit-button','data' => ['target' => 'update_info']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utilities.submit-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['target' => 'update_info']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div> <!-- / .row -->
    </div> <!-- / .container-fluid -->
</div><?php /**PATH /home/consolac/universalinstant.org/resources/views/livewire/admin/profile.blade.php ENDPATH**/ ?>