

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Manage Deposits
    </h1>

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            User
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Deposit Method
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Amount
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Comment
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">

                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td> <a href="<?php echo e(route('admin.user-edit', $deposit->user->id)); ?>"> <?php echo e($deposit->user->name); ?> </a></td>
                                        <td> <?php echo e($deposit->method->name); ?> </td>
                                        <td> <?php echo e($deposit->total_amount); ?> </td>
                                        <td> <?php echo e($deposit->short_comment); ?> </td>
                                        <td> <?php echo e($deposit->created_at); ?> </td>
                                        <td> <span 
                                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                        'badge', 
                                                        'bg-success' => $deposit->status=='approved',
                                                        'bg-danger' => $deposit->status=='rejected',
                                                        'bg-secondary' => $deposit->status=="pending",
                                                        ]) ?>"> 
                                                        <?php echo e($deposit->status); ?> </span> </td>
                                        <td> 
                                            <a href="<?php echo e(route('admin.deposits.single', $deposit->id)); ?>" class="badge bg-primary badge-lg"><i class="fa fa-eye"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" align="center" class="fw-bold">No deposits yet.</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="mt-6 p-4">
                <?php echo e($deposits->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('includes.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\micha\Documents\Projects\westrovest\resources\views/admin/deposits/all.blade.php ENDPATH**/ ?>