<?php

use Illuminate\Http\Request;
use App\Http\Livewire\Admin\Profile;
use App\Http\Livewire\Auth\Register;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Livewire\Admin\LoginHistory;
use App\Http\Controllers\EmailVerification;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Pages\PageController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Livewire\Admin\GenerateTransaction;
use App\Http\Controllers\Pages\ContactController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Dashboard\ProfileController;
use App\Http\Controllers\Admin\SiteSettingsController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Dashboard\BankCardController;
use App\Http\Controllers\Admin\InternationalController;
use App\Http\Controllers\Admin\LocalTransferController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Admin\Auth\AdminHomeController;
use App\Http\Controllers\Admin\CardManagementController;
use App\Http\Controllers\Auth\ConfirmPasswordController;
use App\Http\Controllers\Admin\Auth\AdminLoginController;
use App\Http\Controllers\Admin\DepositController as AdminDepositController;
use App\Http\Controllers\Admin\DepositMethodController;
use App\Http\Controllers\Admin\LoanController as AdminLoanController;
use App\Http\Controllers\Admin\NewUserController;
use App\Http\Controllers\Dashboard\DepositController;
use App\Http\Controllers\Dashboard\InternationalTransferController;
use App\Http\Controllers\Dashboard\LoanController;
use App\Http\Controllers\Dashboard\PasswordController;
use App\Http\Controllers\Dashboard\TicketController;
use App\Http\Controllers\TransactionController as UserTransactionController;
use App\Http\Controllers\LocalTransferController as UserLocalTransferController;
use App\Models\TransactionLog;
use Carbon\Carbon;

Route::middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'index'])->name('login');
    Route::get('/signup', Register::class)->name('register');
});

//Approve Login
Route::get('approve-login', [LoginController::class, 'appproveLogin'])->name('approve-login');
Route::post('approve-login', [LoginController::class, 'processLoginApproval']);

//Password Confirm
Route::get('password/confirm', [ConfirmPasswordController::class, 'showConfirmForm'])->name('password.confirm');
Route::post('password/confirm', [ConfirmPasswordController::class, 'confirm']);

// Password Reset Routes...
Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::get('password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('password/reset', [ResetPasswordController::class, 'reset'])->name('password.update');

Route::get('/email/verify', [EmailVerification::class, 'showVerificationPage'])->middleware(['auth'])->name('verification.notice');

Route::get('/email/verify/{id}/{hash}', [EmailVerification::class, 'EmailVerification'])->middleware(['auth', 'signed'])->name('verification.verify');

Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();

    return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.send');

Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();

    return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.resend');

Route::get('logout', [LoginController::class, 'logout'])->name('logout');
//User Authentication Routes End


//User Routes Start
Route::prefix('dashboard')->group(function () {
    Route::middleware(['auth', 'verified', 'is_active'])->group(function () {
        //User Dashboard
        Route::get('/', [HomeController::class, 'index'])->name('dashboard');
        Route::get('/notification/read/{notification}', [HomeController::class, 'readNotification'])->name('dashboard.read-notification');
        Route::get('/notifications/read', [HomeController::class, 'readAllNotifications'])->name('dashboard.read-notifications');

        Route::get('/deposit/online', [DepositController::class, 'online'])->name('deposit.online');
        Route::post('/deposit/online', [DepositController::class, 'saveOnlineDeposit']);

        Route::get('/deposit/bank', [DepositController::class, 'bank'])->name('deposit.bank');
        Route::post('/deposit/bank', [DepositController::class, 'saveBankDeposit']);

        //Local Transfer Routes
        Route::get('/transfer/local', [UserLocalTransferController::class, 'index'])->name('transfer.local');
        Route::post('/transfer/local', [UserLocalTransferController::class, 'save']);

        //International Transfer Routes
        Route::get('/transfer/international', [InternationalTransferController::class, 'index'])->name('transfer.international');
        Route::post('/transfer/international', [InternationalTransferController::class, 'save']);

        //General Transfer Routes
        Route::prefix('/transfer')->name('transfer.')->group(function () {
            Route::get('/confirm/{transaction:txn_id}', [UserLocalTransferController::class, 'confirm'])->name('confirm');
            Route::post('/confirm/{transaction:txn_id}', [UserLocalTransferController::class, 'confirmCode']);
            Route::post('/resend-otp', [UserLocalTransferController::class, 'resendOTP'])->name('resend-otp')->middleware('throttle:6,1');
            Route::get('/details/{transaction:txn_id}', [UserLocalTransferController::class, 'details'])->name('details');
            Route::post('/details/{transaction:txn_id}', [UserLocalTransferController::class, 'changeTransactionStatus']);
            Route::get('/{transaction:txn_id}', [UserLocalTransferController::class, 'showSuccessPage'])->name('single');
        });

        //Transaction Log Routes
        Route::get('/bank-statement', [UserTransactionController::class, 'index'])->name('bank-statement');

        //Profile Routes
        Route::get('/profile', [ProfileController::class, 'index'])->name('dashboard.profile');
        Route::post('/profile', [ProfileController::class, 'save']);

        //Password Routes
        Route::get('/password', [PasswordController::class, 'index'])->name('dashboard.password');
        Route::post('/password', [PasswordController::class, 'save']);

        Route::get('/loan', [LoanController::class, 'index'])->name('dashboard.loan');
        Route::post('/loan', [LoanController::class, 'save']);
        Route::get('/loans', [LoanController::class, 'all'])->name('dashboard.loans');

        // Card
        Route::get('/request-card', [BankCardController::class, 'index'])->name('dashboard.request-card');
        Route::post('/request-card', [BankCardController::class, 'save']);
        Route::get('/view-card', [BankCardController::class, 'show'])->name('dashboard.view-card');

        //Tickets
        Route::get('/ticket', [TicketController::class, 'index'])->name('dashboard.ticket');
        Route::post('/ticket', [TicketController::class, 'save']);
    });
});

//User Routes End

//Adminstrator Routes Start
Route::prefix('admin')->group(function () {
    //Authentication Routes
    Route::middleware('guest:admin')->group(function () {
        Route::get('/login', [AdminLoginController::class, 'show'])->name('admin.login');
        Route::post('/login', [AdminLoginController::class, 'login']);
        Route::get('logout', [AdminLoginController::class, 'logout'])->name('admin.logout');
    });

    Route::middleware(['admin.auth'])->group(function () {
        //Users Route
        Route::get('/dashboard', [AdminHomeController::class, 'show'])->name('admin.dashboard');
        Route::view('/users', 'admin.users.all')->name('admin.allusers');
        Route::get('/user/view/{user}', [UsersController::class, 'diplayUserDetail'])->name('admin.view-user');
        Route::get('/user/delete/{user}', [UsersController::class, 'deleteUser'])->name('admin.user-delete');
        Route::get('/user/edit/{user}', [UsersController::class, 'displayUserPage'])->name('admin.user-edit');
        Route::post('/user/avatar', [UsersController::class, 'uploadAvatar'])->name('admin.avatar');
        Route::post('/user/basic_info', [UsersController::class, 'updateBasicInfo'])->name('admin.basic_info');
        Route::post('/user/password', [UsersController::class, 'updatePassword'])->name('admin.password');
        Route::post('/user/cred_deb', [UsersController::class, 'creditOrDebit'])->name('admin.cred_deb');
        Route::post('/users/deactivate', [UsersController::class, 'activateDeactivateUsers'])->name('admin.activate_deactivate');
        Route::get('/user/login/{user}', [UsersController::class, 'loginAsUser'])->name('admin.user-login');
        Route::post('/user/{user}/transfer-settings', [UsersController::class, 'changeTransferSettings'])->name('admin.transfer-validations');

        Route::view('/user/create', 'admin.users.create')->name('admin.user_signup');
        Route::post('/user/create', [NewUserController::class, 'save']);

        //Admin Transactions Routes
        Route::get('/transactions', [TransactionController::class, 'displayAllTransactions'])->name('admin.all_transactions');
        Route::get('/transaction/{transaction:txn_id}', [TransactionController::class, 'displayTransactionDetail'])->name('admin.transaction-details');
        Route::post('/transaction/{transaction:txn_id}/edit', [TransactionController::class, 'editTransaction'])->name('admin.edit-transaction');
        Route::post('/transaction/{transaction:txn_id}/change-status', [TransactionController::class, 'changeStatus'])->name('admin.change-transaction-status');
        Route::get('/transaction/{transaction:txn_id}/transaction-receipt', [TransactionController::class, 'generateReceipt'])->name('admin.transaction-receipt');

        //Login History and Transaction Generator Route
        Route::get('/transactions/generate', GenerateTransaction::class)->name('transaction.generate');
        Route::get('/history', LoginHistory::class)->name('login.history');

        //International Request Routes
        Route::get('/pending-transfers', [InternationalController::class, 'index'])->name('admin.all_requests');
        Route::post('/international-request/change-status', [InternationalController::class, 'changeStatus'])->name('admin.update_requests');

        //Site Settings Routes
        Route::get('/settings', [SiteSettingsController::class, 'displaySettingsPage'])->name('admin.site_settings');
        Route::put('/settings/update', [SiteSettingsController::class, 'updateSiteSettings'])->name('admin.update_settings');

        //Email Configuration
        Route::get('/config', [SiteSettingsController::class, 'displayConfigPage'])->name('settings.config');
        Route::put('/update-config', [SiteSettingsController::class, 'updateConfig'])->name('settings.update-config');
        Route::post('/config/test-email', [SiteSettingsController::class, 'sendTestEmail'])->name('settings.email-test');

        //Deposit Methods
        Route::get('/deposit-methods', [DepositMethodController::class, 'index'])->name('settings.deposit-methods');
        Route::get('/deposit-methods/{method}', [DepositMethodController::class, 'single'])->name('settings.deposit-methods.single');
        Route::post('/deposit-methods/{method}', [DepositMethodController::class, 'save']);
        Route::get('/methods/create-bank', [DepositMethodController::class, 'createBank'])->name('settings.methods.create-bank');

        Route::get('/methods/create-crypto', [DepositMethodController::class, 'createCrypto'])->name('settings.methods.create-crypto');
        Route::post('/methods/create-crypto', [DepositMethodController::class, 'create'])->name('settings.deposit-methods.create');


        Route::get('/deposit-methods/{method}/delete', [DepositMethodController::class, 'delete'])->name('settings.deposit-methods.delete');

        //Admin Local Transfer Route
        Route::view('/transfer/local', 'admin.transfer')->name('admin.local_transfer');
        Route::post('/transfer/local', [LocalTransferController::class, 'save']);

        //Admin Profile Route
        Route::get('/profile', Profile::class)->name('admin.profile');

        //Card Management
        Route::get('/cards', [CardManagementController::class, 'index'])->name('admin.cards');
        Route::get('/cards/{card}', [CardManagementController::class, 'show'])->name('admin.view-card');
        Route::post('/cards/{card}', [CardManagementController::class, 'save']);
        Route::get('/cards/{card}/delete', [CardManagementController::class, 'delete'])->name('admin.delete-card');

        //Deposits
        Route::get('/deposits', [AdminDepositController::class, 'index'])->name('admin.deposits.all');
        Route::get('/deposits/{deposit}', [AdminDepositController::class, 'single'])->name('admin.deposits.single');
        Route::post('/deposits/{deposit}', [AdminDepositController::class, 'update']);
        Route::get('/deposits/{deposit}/delete', [AdminDepositController::class, 'delete'])->name('admin.deposits.delete');

        //Loans
        Route::get('/loans', [AdminLoanController::class, 'index'])->name('admin.loans');
    });
});
//Admin Routes End

Route::get('/test', function () {
    $transactions = TransactionLog::where('alert_type', 'debit')->where('details', '!=', 'null')->where('creator', 'user')->get();
    // dd($transactions);
     $transactions->each(function($transaction) {
        $transaction->update([
            'details->sender_account_number' => $transaction->user->account_number,
            'details->sender_name' => $transaction->user->name,
        ]);
     });
});

Route::view('/', 'pages.index');
Route::post('/contact', [ContactController::class, 'send'])->name('pages.contact');
Route::get('/{name}', [PageController::class, 'index']);
