<form method="POST" method="POST" enctype="multipart/form-data" x-data="online_deposit_form(@js($methods))">
    @csrf
    <div class="modal-account__pane-header" style="background-color:#1244df; padding:10px;">
        <h4 style="color: #ffffff; font-size:18px">Online Deposit</h4>
    </div>

    <div class="modal-account__right tab-content">

        <div class="modal-account__pane tab-pane show active" id="accountDetails">
            <div class="box">
                <div class="box-body"></div>
                <div class="row row--md">
                    <div class="col-12">
                        <label class="form-label form-label--sm text-primary">Crypto Type:
                        </label>
                        <div class="input-group input-group--append">

                            <x-form.select name="method_id"  class="input input--fluid"
                                @change="selectMethod($event.target.value)">

                                @if(old('method_id'))
                                <option value="{{ old('method_id') }}">{{ old('method_id') }}</option>
                                @else
                                <option value="">Choose a method</option>
                                @endif
                                
                                @foreach ($methods as $method)
                                <option value="{{ $method->id }}"> {{ $method->name }} </option>
                                @endforeach
                            </x-form.select>

                        </div>
                    </div>

                    <div class="col-12 mt-4">
                        <label class="form-label form-label--sm text-primary">Copy Wallet Address: </label>
                        <div class="input-group mb-3">
                            <input type="text" disabled class="shadow-none input form-control" type="text" name="" id="copycrypto"
                                placeholder="Payment Address" 
                                :value="selected_method?.details?.wallet_address">

                            <div class="input-group-append" x-cloak x-show="selected_method.details !== undefined">
                                <button class="btn btn-outline-primary" type="button" @click="copyMethodAddress"><span
                                        class="button__text">copy
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 mt-1">
                        <div class="row row--md">
                            <div class="col-md-6 form-group form-group--lg">
                                <label class="form-label form-label--sm">Receiver (Customer
                                    Care Loan Department)</label>
                                <div class="input-group">
                                    <input class="input" type="text" placeholder="Customer Billing" disabled >
                                </div>
                            </div>
                            <div class="col-md-6 form-group form-group--lg">
                                <label class="form-label form-label--sm">Cash Deposit
                                    Amount</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon1">{{ $user->details->currency }}</span>
                                      </div>
                                    <x-form.input type="number" class="input" name="amount" placeholder="Enter deposit amount" value="{{ old('amount') }}" />
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <label class="form-label form-label--sm text-primary">Upload Payment Proof:
                        </label>
                        <div class="row row--md">
                            <div class="col-12 form-group--lg">
                                <div class="input-group">
                                    <x-form.input class="input" name="photo_proof" type="file" />
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-12">
                        <div class="row row--md">
                            <div class="col-12 form-group form-group--lg">
                                <label class="form-label form-label--sm">Comment</label>
                                <div class="input-group">
                                    <x-form.textarea name="comment" placeholder="Comment" rows=5  class="input" value="{{ old('comment') }}" />
                                </div>
                            </div>

                        </div>
                    </div>


                </div>
                <div class="card-order__footer-total pt-3">

                    <div class="card__container pl-0">
                        <div class="row gutter-bottom-sm justify-content-end">
                            <div class="card-order__footer-submit col-12 col-sm">
                                <button class="my-btn" name="deposit" type="submit"><span class="button__text">Submit</span>
                                </button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>

</script>