<div>
    <div class="card" x-data="{isTransferConfirmed: false, isTransferDone:false}" @transfer-confirmed.window="isTransferConfirmed = true" @transfer-done.window="isTransferDone = true">
  
		<div class="card-body">
			<section x-show="!isTransferConfirmed">
				<form wire:submit.prevent="saveTransfer" method="POST">
					@csrf
					<div class="row mb-5">
						<div class="col-md-6 mb-5">
							<div class="form-group">
								<label class="form-label">Beneficiary Name</label>
								<input type="text" class="@error('beneficiary_name')is-invalid @enderror form-control" wire:model="beneficiary_name"  autocomplete="on"/>
								@error('beneficiary_name')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
							</div>
						</div>
						<div class="col-md-6 mb-5">
							<div class="form-group">
								<label class="form-label">Beneficiary Account Number</label>
								<input type="text" class="@error('beneficiary_account_number')is-invalid @enderror form-control" wire:model="beneficiary_account_number" autocomplete="on"/>
								@error('beneficiary_account_number')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
							</div>
						</div>
						<div class="col-md-6 mb-5">
							<div class="form-group">
								<label class="form-label">Beneficiary Bank</label>
								<input type="text" class="@error('beneficiary_bank')is-invalid @enderror form-control" wire:model="beneficiary_bank" autocomplete="on"/>
								@error('beneficiary_bank')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
							</div>
						</div>
						<div class="col-md-6 mb-5">
							<div class="form-group">
								<label class="form-label">Beneficiary Swift Code</label>
								<input type="text" class="@error('swift_code')is-invalid @enderror form-control" wire:model="swift_code" autocomplete="on"/>
								@error('swift_code')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
							</div>
						</div>
						<div class="col-md-6 mb-5">
							<div class="form-group">
								<label class="form-label">Routing Transit Number(RTN)</label>
								<input type="text" class="@error('rtn')is-invalid @enderror form-control" wire:model="rtn" autocomplete="on"/>
								@error('rtn')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
							</div>
						</div>
						<div class="col-md-6 mb-5 d-none" d-none>
							<div class="form-group">
								<label class="form-label">Currency</label>
								<select class="form-select @error('currency')is-invalid @enderror" wire:model="currency">
									<option value="">Select One</option>
									<option value="dollar" selected>USD</option>
									<option value="euro">EUR</option>
									<option value="pound">GBP</option>
								</select>
								@error('currency')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
							</div>
						</div>
						<div class="col-md-6 mb-5" >
							<div class="form-group">
								<label class="form-label">Amount</label>
								<input type="text" class="@error('amount')is-invalid @enderror form-control" wire:model="amount" autocomplete="on"/>
								@error('amount')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
								@enderror
								<div class="text-info">
									<strong><small style="font-size: 10px" class="mx-auto ml-5"> Transfer charge of {{settings()->charges['international']}}% applies</small></strong>
								</div>
							</div>
						</div>
					</div>
					<div class="row mb-5">
						<label class="form-label">Purpose of Transfer</label>
						<div class="col">
							<textarea wire:model="purpose" class="@error('purpose')is-invalid @enderror form-control" cols="20" rows="7" autocomplete="on"> </textarea>
							@error('purpose')
							<span class="invalid-feedback" role="alert">
								<strong>{{ $message }}</strong>
							</span>
							@enderror
						</div>
					</div>
					<div class="text-center" @transfer-confirmed.window="isTransferConfirmed = true" @transfer-done.window="isTransferDone = true">
						<button class="btn btn-primary" type="button" disabled wire:loading wire:target="saveTransfer">
							<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
							<span class="sr-only">Processing...</span>
						</button>
						<button class="btn btn-primary btn-block mt-4" :class="{'btn-success': isTransferConfirmed}" type="submit" disabled :disabled="isTransferDone" wire:loading.remove wire:target="saveTransfer">
							<span x-text="$wire.status_text"></span>  
						</button>
					</div>
				</form>
			</section>
			<div class="row" x-show="isTransferConfirmed" x-cloak>
			    
			    	    
<style>

/* Styles for the progress bar container */
.progress-bar {
  width: 100%;
  height: 20px;
  background-color: #f0f0f0;
  margin-bottom: 15px;
  border-radius: 5px;
  overflow: hidden;
}

/* Styles for the progress bar */
.t-progress {
  height: 100%;
  background-color: darkgreen;
  border-radius: 5px;
  color: #fff;
  text-align: center;
  line-height: 20px; /* Vertically center the text */
  animation: progressAnimations 5s ease-in-out forwards;
}

/* Animation keyframes for the progress bar */
@keyframes progressAnimations {
  0% {
    width: 60%;
  }
  100% {
    width: 100%;
  }
}

  </style>
  
				<div align="center">
          <img src="/assets/images/success.gif" style="height: 30%"/>
					<div> 
					
					<div class="progress-bar">
                      <div class="t-progress" id="my-Progress" data-value="60%">
                          100%
                    </div>
                    </div>
                    
						<h1>Transaction Completed</h1>
						<p class="fw-bolder">This transaction is successful. Your transaction is expected to be completed after 24 hours.</p>
					</div>

                    
					<a href={{ url('/dashboard/transaction/'.session('transaction_id')) }}>
					<button class="btn btn-primary">
					    View Transaction Details
					 </button>
					 </a>
					  <td colspan="2" class="text-center">Generate Receipt <br>
					  <a href="{{ url('/dashboard/transaction/pdf/'.session('transaction_id')) }}" target="_blank">
					      <i class="material-icons p-5 cursor-pointer">picture_as_pdf</i> 
					  </a>
                    <a href="{{ url('/dashboard/transaction/view/'.session('transaction_id')) }}" target="_blank">
                    <i class="material-icons cursor-pointer">print</i>
                    </a>
                    </td>
				</div>
			</div>
		</div>
	</div>

	@include('includes.user.confirm-transaction')
</div>
