<div>
    <div class="container-fluid">

        <div class="d-flex align-items-baseline justify-content-between">

            <!-- Title -->
            <h1 class="h2">
                Login History
            </h1>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Login History</li>
                </ol>
            </nav>
        </div>

        <div class="row">
            <div class="col">

                <!-- Card -->
                <div class="card">
                    <div class="card-body">
                        <!-- Table -->
                        <div class="table-responsive">
                            <div>
                                <table class="table table-responsive table-edge table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>
                                                <a class="text-muted">
                                                    Name
                                                </a>
                                            </th>

                                            <th>
                                                <a class="text-muted">
                                                   Email
                                                </a>
                                            </th>
                                            <th>
                                                <a class="text-muted">
                                                    Ip address
                                                </a>
                                            </th>
                                            <th>
                                                <a class="text-muted">
                                                    Time
                                                </a>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="list">
                                        @forelse ($histories as $history)
                                        <tr>
                                            <td>{{ $history->user->name }}</td>
                                            <td>{{$history->user->email}}</td>
                                            <td>{{$history->ip}}</td>
                                            <td>{{$history->created_at->format('jS F, Y h:i A')}}</td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="6" align="center" class="fw-bold">No logins yet</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{$histories->links()}}
                            </div>
                        </div> <!-- / .table-responsive -->
                    </div>
                </div> <!-- / .row -->
            </div>
        </div>
    </div>
</div>