@extends('includes.adminlayout')
@section('content')
<div class="container">
  <div class="card">
    <div class="card-body">
      <h3 class="text-center">Configurations</h3>
      <hr>
      <form method="POST" id="configForm">
        @method('put')
        @csrf
        <div class="row">
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_driver">Mail Driver</label>
            <input name="mail_driver" type="text" class="form-control" value="{{$settings->mail_driver}}"
              placeholder="eg. smtp">
          </div>
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_host">Mail Host</label>
            <input name="mail_host" type="text" class="form-control" value="{{$settings->mail_host}}"
              placeholder="eg. mail.domain.com">
          </div>
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_port">Mail Port</label>
            <input name="mail_port" type="text" class="form-control" value="{{$settings->mail_port}}"
              placeholder="eg. 465">
          </div>
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_from">Mail From</label>
            <input name="mail_from" type="text" class="form-control" value="{{$settings->mail_from}}"
              placeholder="eg. Zinc Banking">
          </div>
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_encryption">Mail Encryption</label>
            <input name="mail_encryption" type="text" class="form-control" value="{{$settings->mail_encryption}}"
              placeholder="eg. ssl">
          </div>
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_username">Mail Username</label>
            <input name="mail_username" type="text" class="form-control" value="{{$settings->mail_username}}"
              placeholder="eg. username@domain.com">
          </div>
          <div class="col-md-6 col-xl-4 col-sm-12 mb-5">
            <label class="form-label" for="mail_password">Mail Password</label>
            <input name="mail_password" type="text" class="form-control" value="{{$settings->mail_password}}"
              placeholder="SMTP Password">
          </div>
        </div>
        <!-- Button -->
        <button id="loading" class="btn btn-primary" type="button" disabled style="display: none">
          <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
          <span class="sr-only">Loading...</span>
        </button>
        <div class="row">
          <div class="col-6">
            <button id="done" type="submit" class="btn btn-primary">Update</button>
          </div>
          <div class="col-6" align="right">
            <span id="test_button" class="badge text-bg-info animate__animated animate__bounce" role="button"> Test
              Configuration</span>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
<form action="{{route('settings.email-test')}}" method="POST" id="emailTestForm">
  <x-utilities.modal id="testConfiguration" title="Test Email Configuration">
    <div class="row">
      <div class="col-md-12 col-sm-12 col-xl-12 mx-auto mb-5">
        <label class="form-label">Receiver Email Address</label>
        <input type="text" class="form-control" name="email_receiver" required>
      </div>

    </div>
    <x-slot:footer>
      <button id="m_loading" class="btn btn-primary" type="button" disabled style="display: none">
        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
        <span class="sr-only">Loading...</span>
      </button>
      <button id="m_done" type="submit" class="btn btn-primary">Test Configuration
      </button>
    </x-slot:footer>
  </x-utilities.modal>
</form>
<script>
  window.onload = () => {
    var button = document.getElementById('test_button')
    button.addEventListener('click', () => {
        $('#testConfiguration').modal('show')
    })
    setInterval( ()=>{
        if(button.classList.contains('animate__bounce')){
            button.classList.remove('animate__bounce')
        }else{
            button.classList.add('animate__bounce')
        }
    }, 3000 )
}
</script>
@endsection