@extends('includes.adminlayout')

@section('content')
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Manage Loan Requests
    </h1>

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            User
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Amount
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Monthly Income
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Subject
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Note
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                @forelse ($loans as $loan)
                                <tr>
                                    <td> <a href="{{ route('admin.user-edit', $loan->user->id) }}"> {{
                                            $loan->user->name }} </a></td>
                                    <td> {{ $loan->total_amount }} </td>
                                    <td> {{ $loan->income }} </td>
                                    <td> {{ $loan->subject }} </td>
                                    <td> {{ $loan->short_note }} </td>
                                    <td> {{ $loan->created_at }} </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" align="center" class="fw-bold">No loan requests yet.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="mt-6 p-4">
                {{ $loans->links() }}
            </div>
        </div>
    </div>
</div>
@endsection