@extends('includes.adminlayout')

@section('content')
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Manage Deposits
    </h1>

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            User
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Deposit Method
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Amount
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Comment
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">

                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                @forelse ($deposits as $deposit)
                                    <tr>
                                        <td> <a href="{{ route('admin.user-edit', $deposit->user->id) }}"> {{ $deposit->user->name }} </a></td>
                                        <td> {{ $deposit->method->name }} </td>
                                        <td> {{ $deposit->total_amount }} </td>
                                        <td> {{ $deposit->short_comment }} </td>
                                        <td> {{ $deposit->created_at }} </td>
                                        <td> <span 
                                                @class([
                                                        'badge', 
                                                        'bg-success' => $deposit->status=='approved',
                                                        'bg-danger' => $deposit->status=='rejected',
                                                        'bg-secondary' => $deposit->status=="pending",
                                                        ])> 
                                                        {{ $deposit->status }} </span> </td>
                                        <td> 
                                            <a href="{{ route('admin.deposits.single', $deposit->id) }}" class="badge bg-primary badge-lg"><i class="fa fa-eye"></i></a>
                                        </td>
                                    </tr>
                                @empty
                                <tr>
                                    <td colspan="7" align="center" class="fw-bold">No deposits yet.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="mt-6 p-4">
                {{ $deposits->links() }}
            </div>
        </div>
    </div>
</div>
@endsection