@extends('includes.adminlayout')
@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <h3 class="text-center">Create a Crypto Method</h3>
            <hr>
            <form method="POST" action="{{ route('settings.deposit-methods.create') }}">
                @csrf
                <input type="hidden" name="type" value="crypto">
                <div class="row">
                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">
                            Name
                        </label>
                        <x-form.input type="text" name="name" class="form-control" :old="true" />
                    </div>

                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">Status</label>
                        <x-form.select name="is_active" class="form-select">
                            <option value="">Select one</option>
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </x-form.select>
                    </div>

                    <div class="mb-3 col-md-4 mb-5 col-sm-12">
                        <label class="form-label">Wallet Address</label>
                        <x-form.input name="wallet_address" class="form-control shadow-none" required />

                    </div>

                    <div class="mb-3 col-12 d-flex mb-5 justify-content-end">
                        <button class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection