<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Install\InstallController;

//Installation Routes Start
Route::prefix('install')->group(function () {
  Route::get('/', [InstallController::class, 'displayInstallPage'])->name('install');
  Route::post('/first', [InstallController::class, 'processDBConfig'])->name('install.first');
  Route::get('/process-database', [InstallController::class, 'processDbMigration']);
  Route::post('/process-database', [InstallController::class, 'databaseProcess'])->name('extractDatabase');
  Route::get('/second', [InstallController::class, 'displayInstallPageTwo'])->name('install.second');
  Route::post('/second', [InstallController::class, 'processAdminConfig'])->name('install.process_second');
});
//Installation Routes End