$(function () {
    $("#emailTestForm").submit(function (e) {
        e.preventDefault();
        $("#m_done").hide();
        $("#m_loading").show();
        var formData = new FormData(this);
        $.ajax({
            type: "post",
            url: "/admin/config/test-email",
            data: formData,
            dataType: "json",
            contentType: false,
            processData: false,
            success: (response) => {
                $("#m_done").show();
                $("#m_loading").hide();
                $("#testConfiguration").modal("hide");
                if (response.success) {
                    Notify.success(response.success.message)
                } else {
                    Notify.failure('Incorrrect Email Configuration')
                }
            },
            error: (response) => {
                if (response.error) {
                    Notify.failure(response.error.message)
                }
                $("#m_done").show();
                $("#m_loading").hide();
                console.log(response);
                Notify.failure('Wrong Email Configuration, Please try again')
            },
        });
    });

    $("#configForm").submit(function (e) {
        e.preventDefault();
        var formData = new FormData(this);

        $("#done").hide();
        $("#loading").show();
        $.ajax({
            type: "post",
            url: "/admin/update-config",
            data: formData,
            dataType: "json",
            contentType: false,
            processData: false,
            success: function (response) {
                $("#done").show();
                $("#loading").hide();
                if (response.success) {
                    Notify.success(response.success.message)
                }
            },
            error: function (response) {
                $("#done").show();
                $("#loading").hide();
                console.log(response);
                if (response.responseJSON.error) {
                    Notify.failure(response.responseJSON.error.message)
                } else if (response.status == 422) {
                    Notify.failure(response.responseJSON.message)
                } else {
                    Notify.failure('Something went wrong, please try again')
                }
            },
        });
    });
    $("#settingsForm").submit(function (e) {
        e.preventDefault();
        var formData = new FormData(this);
        $.ajax({
            type: "post",
            url: "/admin/settings/update",
            data: formData,
            dataType: "json",
            contentType: false,
            processData: false,
            beforeSend: function () {
                $("#done").hide();
                $("#loading").show();
            },
            success: function (response) {
                $("#done").show();
                $("#loading").hide();

                $.each(response.errors, function (key, value) {
                    Notify.success(value)
                });

                if (response.success) {
                    Notify.success(response.success)
                    setTimeout(() => {
                        location.reload();
                    }, 2000);
                }
            },
            error: function (response) {
                console.log(response.responseJSON);
                $("#done").show();
                $("#loading").hide();
                Notify.failure('Something went wrong, please try again.')
            },
        });
    });
    $("#avatar").change(function () {
        $("#submitButton").show();
        $("#adminAvatarUpload").submit(function (e) {
            e.preventDefault();
            let formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: "/admin/user/avatar",
                dataType: "json",
                data: formData,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $("#submitButton").html("Uploading...");
                    Notify.info('Uploading contents...')
                },
                success: function (data) {
                    if (data.avatar) {
                        $("#submitButton").html(
                            '<span class="text-success">Uploaded!</span>'
                        );
                        Notify.success(data.avatar)
                    }
                    if (data.errors) {
                        $("#submitButton").html(
                            '<span class="text-danger">Upload Failed</span>'
                        );
                        $.each(data.errors, function (key, value) {
                            Notify.failure(value)
                        });
                    }
                    setTimeout(function () {
                        location.reload();
                    }, 1000);
                },
                error: function (data) {
                    Notify.failure(data.avatar)
                },
            });
        });
    });
});

$(document).ajaxStart(function () {
    Pace.restart();
});
paceOptions = {
    ajax: true,
    document: false,
    eventLag: false,
    restartOnRequestAfter: true,
    elements: {
        selectors: [".my-page"],
    },
};
$(document).ready(function () {
    $.ajaxSetup({
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
    });
});

document.addEventListener("alpine:init", () => {
    Alpine.data("validate_transfer", () => ({
        validate_change: '',
        user_id: '',
        processing: false,
        change() {
            this.processing = true
            const url = route('admin.transfer-validations', this.user_id)
            fetch(url, {
                method: "POST",
                body: JSON.stringify({
                    validate_change: this.validate_change,
                }),
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                    Accept: "application/json",
                    "Content-Type": "application/json",
                },
            })
                .then((res) => res.json())
                .then((data) => {
                    this.processing = false
                    Notify.success(data.info)
                })
                .catch((err) => {
                    this.processing = false
                    console.log(err)
                    Notify.failure('Something went wrong, please try again.')
                });
        },
    }));
});
