<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\TransactionLog;
use App\Utils\Enums\AlertType;
use Illuminate\Database\Seeder;
use App\Utils\Enums\TransactionType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class LocalTransactionSeeder extends Seeder {
  /**
   * Run the database seeds.
   *
   * @return void
   */
  public function run() {
    $user = User::firstWhere('username', session('generatee'));
    $latestTransaction = $user->transactions()->oldest()->first();
    $date = !is_null($latestTransaction) ? $latestTransaction->created_at->addMinutes(rand(0, 60)) : now();
    $request = [
      'beneficiary_name' => fake()->name(),
      'beneficiary_account_number' => fake()->creditCardNumber(),
      'receiving_bank' => fake()->company(),
      'beneficiary_email' => fake()->email(),
      'receiving_country' => fake()->country(),
      'swift_code' => fake()->swiftBicNumber(),
      'account_type' => fake()->randomElement(['Savings', 'Fixed Deposit', 'Current']),
      'amount' => fake()->numberBetween(1000, 999999),
    ];
    $type = ucfirst(TransactionType::Local->value);
    $description = "{$type} Transfer of {$request['amount']} to Account {$request['beneficiary_account_number']} ( {$request['beneficiary_name']} ) Bank: {$request['receiving_bank']}";
    $user->transactions()->create([
      'transaction_type' => TransactionType::Local,
      'alert_type' => fake()->randomElement([AlertType::Credit, AlertType::Debit, AlertType::Debit, AlertType::Credit, AlertType::Debit, AlertType::Credit]),
      'status' => 'successful',
      'description' => $description,
      'amount' => fake()->numberBetween(0, 2000),
      'currency' => $user->details->currency,
      'narration' => fake()->name(),
      'details' => $request,
      'creator' => 'user',
      'date' => $date->subDays(2),
      'txn_id' => txn_id(),
      'expires_at' => now()->addHour(),
      'created_at' => $date->subDays(2),
    ]);
  }
}
