<?php

namespace Database\Seeders;

use Carbon\Carbon;
use App\Models\TransactionLog;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ExchangeTransactionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
      $latestTransaction = TransactionLog::where('username', session()->get('generatee'))->oldest()->first();
      $date = !is_null($latestTransaction) ? $latestTransaction->created_at->addMinutes(rand(0, 60)) : now();
        TransactionLog::factory(1)->create([
          'id' => rand(100000000, 999999999),
            'username' => session()->get('generatee'),
            'transaction_type' => 3,
            'alert_type' => fake()->randomElement(['Credit', 'Debit', 'Credit', 'Debit', 'Credit']),
            'date'=> $date->subDays(2)->format('jS F, o. h:i A'),
            'status' => 1,
            'amount'=> fake()->numberBetween(0, 2000),
            'currency'=> session()->get('gen_currency'),
            'note' => fake()->word(), 
            'creator' => session()->get('generatee'),
            'created_at' => $date->subDays(2),
        ]);
    }
}
