<?php

use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_details', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();
            $table->string('account_balance')->default(0);
            $table->string('account_type');
            $table->string('date_of_birth');
            $table->string('address');
            $table->string('country');
            $table->enum('gender', ['male', 'female']);
            $table->string('avatar')->default(asset('/assets/uploads/default.jpg'));
            $table->string('marital_status');
            $table->json('preferences')->nullable();
            $table->string('occupation');
            $table->string('currency');
            $table->string('ssn');
            $table->json('codes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_details');
    }
};