<?php

namespace Database\Factories;

use Carbon\Carbon;
use App\Models\User;
use App\Models\TransactionLog;
use App\Utils\Enums\TransactionType;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\TransactionLog>
 */
class TransactionLogFactory extends Factory {
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition() {
        $user = User::firstWhere('username', session('generatee'));
        $latestTransaction = $user->transactions()->oldest()->first();
        $date = !is_null($latestTransaction) ? $latestTransaction->created_at->addMinutes(rand(0, 60)) : now();
        $request = [
            'beneficiary_name' => fake()->name(),
            'beneficiary_account_number' => fake()->creditCardNumber(),
            'receiving_bank' => fake()->company(),
            'beneficiary_email' => fake()->email(),
            'receiving_country' => fake()->country(),
            'swift_code' => fake()->swiftBicNumber(),
            'account_type' => fake()->randomElement(['Savings', 'Fixed Deposit', 'Current']),
            'amount' => fake()->numberBetween(1000, 999999),
        ];
        $type = ucfirst(TransactionType::Local->value);
        $description = "{$type} Transfer of {$request['amount']} to Account {$request['beneficiary_account_number']} ( {$request['beneficiary_name']} ) Bank: {$request['receiving_bank']}";

        return [
            'id' => rand(100000000, 999999999),
            'username' => request()->session()->get('generatee'),
            'transaction_type' => '2',
            'alert_type' => 'Debit',
            'date' => $date->subDays(2)->format('jS F, o. h:i A'),
            'status' => 1,
            'amount' => fake()->numberBetween(0, 2000),
            'currency' => request()->session()->get('gen_currency'),
            'note' => fake()->name(),
            'details' => [
                'beneficiary_acc_num' => fake()->numberBetween(100000000, 999999999),
                'beneficiary_name' => fake()->name(),
                'beneficiary_bank' => fake()->company() . ' ' . fake()->companySuffix(),
                'beneficiary_swiftcode' => fake()->regexify('[A-Z]{4}[-][A-Z]{2}[-][A-Z]{2}[-][0-9]{3}'),
                'routing_transit_no' => fake()->numberBetween(1000, 9999),
            ],
            'creator' => request()->session()->get('generatee'),
            'created_at' => $date->subDays(2),
        ];
    }
}
