<?php

use App\Models\User;
use App\Models\Setting;
use App\Models\UserDetail;
use App\Models\DepositMethod;
use App\Models\TransactionLog;
use Illuminate\Support\Facades\Auth;


function user() {
    return Auth::user();
}

function admin() {
    return Auth::guard('admin')->user();
}
function customer_details($username) {
    return UserDetail::firstWhere('username', $username);
}
/**
 * The Site Settings
 */
function settings() {
    return Setting::find(1);
}

function getSenderDetail($username) {
    return User::firstWhere('username', $username);
}

function userStatus($status) {
    if ($status == 1) {
        return "Active";
    } else {
        return "Inactive";
    }
}

function account_number() {
    $prefix = '20';
    $account_number = random_int(10000000, 99999999);
    return $prefix . $account_number;
}

function txn_id() {
    return 'TXN' . random_int(1000000000, 9999999999);
}

function shortenWords($text, $wordLimit = 3) {
    $words = explode(' ', $text);
    if (count($words) > $wordLimit) {
        $shortenedText = implode(' ', array_slice($words, 0, $wordLimit)) . '...';
    } else {
        $shortenedText = $text;
    }
    return $shortenedText;
}

function convertText($input) {
    $words = explode('_', $input);
    $words = array_map('ucfirst', $words);
    return implode(' ', $words);
}
