<?php

namespace App\Notifications\User;

use App\Models\Setting;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class Welcome extends Notification 
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(public User $user) {
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage {
        $settings = Setting::first();
        return (new MailMessage)
            ->subject("Welcome to {$settings->site_name}")
            ->greeting("Dear {$this->user->name}")
            ->line("Welcome to {$settings->site_name}! We are thrilled to have you join our community of smart banking.")
            ->line('Your account has been successfully created, and you are now ready to experience secure and easy banking.')
            ->line('Here are a few things you can do to get started:')
            ->line('1. Log in to your account: Access your account securely')
            ->line("2. Explore our services: Whether it's savings, loans, or investments, we have a solution tailored for you.")
            ->line('3. Stay updated: Get the latest updates and personalized offers via email.')
            ->line("Your Two-Factor Pin is {$this->user->pin}. Please, remember this pin.")
            ->line("At {$settings->site_name}, we value your trust and are committed to providing you with the best banking experience.")
            ->line("Should you have any questions, feel free to reach out to our support team at {$settings->site_email}.")
            ->line("Thank you for choosing {$settings->site_name}!")
            ->action('Dashboard', route('login'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array {
        $settings = Setting::first();

        return [
            'title' => "Welcome to {$settings->site_name}",
            'message' => "Dear {$this->user->name}, your account has been successfully created at {$settings->site_name}.",
        ];
    }
}
