<?php

namespace App\Notifications\User;

use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OTP extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(public int $validity = 10, public array $action = []) {}

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $settings = Setting::first();
        return (new MailMessage)
                    ->subject('Your OTP')
                    ->greeting("Dear {$notifiable->name},")
                    ->line('Thank you for using our service!')
                    ->line('To complete your request, please use the following One-Time Password (OTP)')
                    ->line("Your OTP: {$notifiable->otp->code}")
                    ->line("This OTP is valid for {$this->validity} minutes.")
                    ->line('Please do not share this code with anyone.')
                    ->line('If you did not request this code, please ignore this email.')
                    ->actionIf(!empty($this->action), $this->action['text'] ?? '', $this->action['url'] ?? '');
    }
}
