<?php

namespace App\Models;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        "otp" => "object",
        'is_active' => 'boolean'
    ];

    public function isActive(){
        return $this->is_active == 1;
    }
    
    public function details() {
      return $this->hasOne(UserDetail::class);
    }

    public function transactions() {
        return $this->hasMany(TransactionLog::class);
    }

    public function login_history() {
        return $this->hasMany(LoginHistory::class);
    }

    protected function lastLogin(): Attribute {
        return Attribute::make(get: fn() => $this->login_history()->latest()->first());
    }

    public function deposits() {
        return $this->hasMany(Deposit::class);
    }

    protected function totalBalance(): Attribute {
        return Attribute::make(get: fn() => $this->details->currency.number_format($this->details->account_balance, 2));
    }

    public function loans() {
        return $this->hasMany(Loan::class);
    }

    public function card() {
        return $this->hasOne(Card::class);
    }

    public function contacts() {
        return $this->hasMany(Contact::class, 'email', 'email');
    }

    public static function search($string) {
        return parent::where(function($query) use($string) {
            $query->where('username', 'like', $string.'%',)
            ->orWhere('email', 'like', $string.'%')
            ->orWhere('account_number', 'like', $string.'%')
            ->orWhere('name', 'like', $string.'%');
        });
    }

    public function validateTransfer() {
        return $this->details->permissions?->validate_transfer;
    }
}
