<?php

namespace App\Models;

use App\Utils\Enums\AlertType;
use App\Utils\Enums\TransactionType;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionLog extends Model {

    use HasFactory;
    
    protected $guarded = ['id'];

    protected $casts = [
        'details' => 'object',
        'date' => 'datetime',
        'alert_type' => AlertType::class,
        'transaction_type' => TransactionType::class,
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    protected function totalAmount(): Attribute {
        return Attribute::make(get: fn() => $this->currency.number_format($this->amount, 2));
    }

    protected function shortDescription(): Attribute {
        return Attribute::make(get: fn() => shortenWords($this->description));
    }

    protected function type(): Attribute {
        return Attribute::make(get: fn() => ucfirst($this->transaction_type->value));
    }

    protected function beneficiary(): Attribute {
        return Attribute::make(get: fn() => User::firstWhere('account_number', $this->details?->beneficiary_account_number));
    }

    protected function sender(): Attribute {
        return Attribute::make(get: fn() => User::firstWhere('account_number', $this->details?->sender_account_number));
    }
}
