<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'charges' => 'object',
        'preferences' => 'object',
        'verify_email' => 'boolean',
    ];

    protected function siteDomain(): Attribute {
        return Attribute::make(fn() => parse_url($this->site_url, PHP_URL_HOST));
    }
}
