<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function user() {
        return $this->belongsTo(User::class);
    }

    protected function totalAmount(): Attribute {
        return Attribute::make(get: fn() => $this->user->details->currency.number_format($this->amount, 2));
    }

    protected function income(): Attribute {
        return Attribute::make(get: fn() => $this->user->details->currency.number_format($this->amount, 2));
    }

    protected function shortNote() :Attribute {
        return Attribute::make(get: fn() => shortenWords($this->note));
    }
}
