<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    use HasFactory;

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function method() {
        return $this->belongsTo(DepositMethod::class, 'deposit_method_id');
    }

    protected function totalAmount(): Attribute {
        return Attribute::make(get: fn() => $this->currency.number_format($this->amount, 2));
    }

    protected function shortComment(): Attribute {
        return Attribute::make(get: fn() => shortenWords($this->comment));
    }

    protected function actualStatus(): Attribute {
        return Attribute::make(get: fn() => $this->status);
    }

    public function done() {
        return $this->status=='approved' || $this->status=='rejected';
    }
}
