<?php

namespace App\Listeners;

use App\Events\UserLoggedIn;

class StoreUserLoginHistory
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\UserLoginHistory  $event
     * @return void
     */
    public function handle(UserLoggedIn $event)
    {

        //User Details
        $user = $event->user;

        $history = $user->login_history()->create([
            'ip' => request()->ip(),
        ]);

        return $history;
    }
}
