<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureAdminIsAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::guard('admin')->user()) {
            return $next($request);
        }
        else{
            return redirect(route('admin.login'));
        }
        if ($request->ajax() || $request->wantsJson()) {
            return response('Unauthorized.', 401);
        }
        if (!Auth::user() || !Auth::guard('admin')->user()) {
            return redirect(route('login'));
        }
    }
}

// "All I Want" by Kodaline
// "Fix You" by Coldplay
// "Hallelujah" by Jeff Buckley
// "The Sound of Silence" by Disturbed
// "Say You Love Me" by Jessie Ware
// "Skinny Love" by Bon Iver
// "A Thousand Years" by Christina Perri
// "Breathe Me" by Sia
// "The Scientist" by Coldplay
