<?php

namespace App\Http\Livewire\Utils;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\TransactionLog;

class TransactionsList extends Component
{
    use WithPagination;
    
    //Use Bootstrap Pagination
    protected $paginationTheme = 'bootstrap';


    public function render()
    {
        return view('livewire.utils.transactions-list', [
            'transactions' => TransactionLog::where('username', user()->username)
            ->orderByRaw("STR_TO_DATE(date, '%D %M, %Y. %h:%i %p') DESC")
            ->latest()
            ->get(),
        ]);
    }
    
}
